/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/


#include <stdio.h>
#include <stdlib.h>
#include "AInput.h"
using namespace std;

AInput::AInput(){
    handle=AF_NULL_FILEHANDLE;
    info.nsamples=0;
    info.nchannels=0;
    info.samplerate=1;
    eof=false;
};

AInput::~AInput(){
    close();
};

bool AInput::open(string filename){
    close();//inchide un posibil fisier existent
    handle=afOpenFile(filename.c_str(),"r",0);
    if (handle==AF_NULL_FILEHANDLE){//eroare
	eof=true;
	return(false);
    };
    eof=false;
    info.nsamples=afGetFrameCount(handle,AF_DEFAULT_TRACK);
//    printf("cucurigu %d\n",info.nsamples);
    info.nchannels=afGetVirtualChannels(handle,AF_DEFAULT_TRACK);
    info.samplerate=(int) afGetRate(handle,AF_DEFAULT_TRACK);
        	
    //fac ca intrarea sa fie pe 16 biti
    afSetVirtualSampleFormat(handle,AF_DEFAULT_TRACK,AF_SAMPFMT_TWOSCOMP,16);
    return(true);
};

void AInput::close(){
    if (handle!=AF_NULL_FILEHANDLE){
	afCloseFile(handle);
	handle=AF_NULL_FILEHANDLE;
    };
};

int AInput::read(int nsmps,short int *smps){
    if (handle==AF_NULL_FILEHANDLE) return 0;

    int readed=afReadFrames(handle,AF_DEFAULT_TRACK,smps,nsmps);
    if (readed!=nsmps) eof=true;
    return readed;
};
