/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "ImgInput.h"
#include <iostream> 
#include <stdio.h>
using namespace std;
using namespace Magick;

ImgInput::ImgInput(){
};
ImgInput::~ImgInput(){
};

bool ImgInput::open(string filename){
    info.sizex=0;
    info.sizey=0;
    try{
	image.read(filename);
	info.sizex=image.size().width();
	info.sizey=image.size().height();
	return true;
    } catch( Exception &error_ ) {
    	return false;
    };
};

void ImgInput::readrow(int mode,int channel,int nrow, unsigned char *data){
    Pixels view(image);
    PixelPacket *pixels = view.get(0,nrow,info.sizex,1); 
    if (!pixels) {
	for (int i=0;i<info.sizex;i++) data[i]=0;
	return;
    };
    
    if (mode==0){
	for (int i=0;i<info.sizex;i++) {
	    data[i]=((int)pixels[i].red+(int)pixels[i].green+(int)pixels[i].blue)/768;
	};
	return;
    };
    if (mode==1){
	switch (channel){
	    case 0:
	    	for (int i=0;i<info.sizex;i++) data[i]=pixels[i].red&0xff;
	        break;
	    case 1:
		for (int i=0;i<info.sizex;i++) data[i]=pixels[i].green&0xff;
		break;
	    case 2:
		for (int i=0;i<info.sizex;i++) data[i]=pixels[i].blue&0xff;
	    break;
	};
    };
    
};


