/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <stdio.h>
#include <math.h>
#include "Img.h"
#include "../IO/ImgInput.h"
#include "../IO/ImgOutput.h"

using namespace std;

Img::Img(int nx_,int ny_):Object(){
    type=IMG;
    reset(nx_,ny_);
};

Img::Img(){
    type=IMG;
    reset(0,0);
};
Img::Img(string filename):Object(){
    type=IMG;
    nx=0;ny=0;
    loadfile(filename);
};

Img::~Img(){
};

Img::Img(Img *other){
    nx=other->nx;
    ny=other->ny;
    copyfrom(other);
};


void Img::reset(int nx_,int ny_){
    nx=nx_;
    if (ny_==0) ny_=nx_;
    ny=ny_;
    setdatasize(nx*ny+nx);
};

void Img::savecustomdata(FILE *f){
    int header=0x00676d49;
    fwrite(&header,4,1,f);
    
    fwrite(&nx,sizeof(nx),1,f);
    fwrite(&ny,sizeof(ny),1,f);
};

bool Img::loadcustomdata(FILE *f){
    int header=0x00676d49,h=0;
    fread(&h,4,1,f);
    if (h!=header) return false;
    
    
    fread(&nx,sizeof(nx),1,f);
    fread(&ny,sizeof(ny),1,f);
    return true;
};

bool Img::import_image(std::string filename,int mode,int channel,int sizex,int sizey){
    ImgInput ii;
    if (ii.open(filename)){
	if (ii.info.sizex>sizex) sizex=ii.info.sizex;
	if (ii.info.sizey>sizey) sizey=ii.info.sizey;
	reset(sizex,sizey);
	unsigned char data[ii.info.sizex];
	for (int j=0;j<ii.info.sizey;j++){
	    ii.readrow(mode,channel,j,data);
	    for (int i=0;i<ii.info.sizex;i++) set(i,j,(data[i]-128)*0.0078125);//*1.0/128.0
	};
    } else {
	reset(0,0);
	return false;
    };
    return true;
};

bool Img::export_image(std::string filename,bool logarithm){
    //get max, min
    REALTYPE max=0;
    for (int i=0;i<nx*ny;i++){
	REALTYPE x=fabs(data[i]);
	if (x>max) max=x;
    };
    
    if (max<1e-8) max=1e-8;
    max=1.0/max;

    ImgOutput out(nx,ny);
    out.newfile(filename);
    REALTYPE mm=0.00001,lmm=log(mm);
    for (int j=0;j<ny;j++){
	unsigned char data[nx];
	for (int i=0;i<nx;i++) {
	    REALTYPE x=get(i,j)*max;
	    if (logarithm){
		bool sign=(x<0);
		if (sign) x=-x;
		if (x>mm) x=(lmm-log(x))/lmm;
		    else x=0.0;
		if (sign) x=-x;
	    };
	    data[i]=(int)(x*127.0)+128;
	};
	out.writerow(data);
    };
    out.closefile();
};


void Img::debug(){
    if ((getnx()>5000)||(getny()>5000)){
	printf( "Img: DEBUG ERROR: nx=%d  ny=%d too big for debug\n",getnx(),getny());
	return;
    } else {
	printf( "Img: DEBUG nx=%d  ny=%d\n",getnx(),getny());
	for (int j=0;j<getny();j++){
	    for (int i=0;i<getnx();i++){
		REALTYPE x=get(i,j);
	    if (fabs(x)<0.00001) x=0;
		printf("%.4g\t",x);
		
	    };
	    printf("\n");
	};
    };
};


