/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef IMG_H
#define IMG_H
#include "Object.h"
#include <math.h>

class Img:public Object{
    public:
	Img(int nx_,int ny_);
	Img();
	Img(std::string filename);
	~Img();
	Img(Img *other);

	void reset(int nx_=0,int ny_=0);
	bool import_image(std::string filename,int mode=0,int channel=0,int sizex=0,int sizey=0);
	bool export_image(std::string filename,bool logarithm=false);
	
	inline REALTYPE get(int x,int y){
	    if ((x<0)||(y<0)||(x>=nx)||(y>=ny)) return 0.0;
	    return data[y*nx+x];
	};
	inline REALTYPE get_interpolated(REALTYPE x,REALTYPE y){
	    if ((nx==0)||(ny==0)) return 0.0;
	    int ix=(int)(floor(x));
	    if (ix<0) ix=nx+ix%nx;
		else ix=ix%nx;
	    int iy=(int)(floor(y));
	    if (iy<0) iy=ny+iy%ny;
		else iy=iy%ny;
	    REALTYPE fx=x-floor(x);
	    REALTYPE fy=y-floor(y);
	    return (data[iy*nx+ix]*(1.0-fx)+data[iy*nx+ix+1]*fx)*(1.0-fy)+
		(data[(iy+1)*nx+ix]*(1.0-fx)+data[(iy+1)*nx+ix+1]*fx)*fy;
	};
	inline void set(int x,int y,REALTYPE val){
	    if ((x<0)||(y<0)||(x>=nx)||(y>=ny)) return;
	    data[y*nx+x]=val;
	};
	int getnx(){return nx;};
	int getny(){return ny;};
	void debug();
	
    private:
	void savecustomdata(FILE *f);
	bool loadcustomdata(FILE *f);
	int nx,ny;
};



#endif
