/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <stdio.h>
#include <math.h>
#include "ImgFreq.h"

using namespace std;

ImgFreq::ImgFreq(int nx_,int ny_):Object(){
    type=IMGFREQ;
    reset(nx_,ny_);
};

ImgFreq::ImgFreq(){
    type=IMGFREQ;
    reset(0,0);
};

ImgFreq::ImgFreq(string filename):Object(){
    type=IMGFREQ;
    nx=0;ny=0;
    loadfile(filename);
};

ImgFreq::~ImgFreq(){
};

ImgFreq::ImgFreq(ImgFreq *other){
    nx=other->nx;
    ny=other->ny;
    copyfrom(other);
};


void ImgFreq::reset(int nx_,int ny_){
    nx=nx_;
    ny=ny_;
    setdatasize(nx*(ny+4)+4);
};


void ImgFreq::savecustomdata(FILE *f){
    int header=0x46676d49;
    fwrite(&header,4,1,f);
    
    fwrite(&nx,sizeof(nx),1,f);
    fwrite(&ny,sizeof(ny),1,f);
};

bool ImgFreq::loadcustomdata(FILE *f){
    int header=0x46676d49,h=0;
    fread(&h,4,1,f);
    if (h!=header) return false;
    
    
    fread(&nx,sizeof(nx),1,f);
    fread(&ny,sizeof(ny),1,f);
    return true;
};
REALTYPE ImgFreq::get_max_amplitude(){
    REALTYPE max_amplitude=0.0;
    for (int j=0;j<ny/2+1;j++){
        for (int i=-(nx+1)/2;i<nx/2;i++){
	    REALTYPE c,s;
	    get(i,j,c,s);
	    REALTYPE amp=sqrt(s*s+c*c);
	    max_amplitude=max(max_amplitude,amp);
	};
    };
    if (max_amplitude<1e-8) max_amplitude=1e-8;
    return max_amplitude;
};


void ImgFreq::debug(){
    if ((nx>500)||(ny>500)){
	printf( "ImgFreq: DEBUG ERROR: nx=%d  ny=%d too big for debug\n",getnx(),getny());
	return;
    } else {
	printf( "ImgFreq: DEBUG nx=%d  ny=%d\n",getnx(),getny());
	for (int j=0;j<ny/2+1;j++){
	    for (int i=-(nx+1)/2;i<nx/2;i++){
		REALTYPE s,c;
		get(i,j,c,s);
		if (fabs(c)<0.001) c=0;
		if (fabs(s)<0.001) s=0;
		printf("(%3.2g %3.2g)\t",c,s);
		
	    };
	    printf("\n\n");
	};
    };
};

