/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef IMGFREQ_H
#define IMGFREQ_H
#include "Object.h"
#include <math.h>
class ImgFreq:public Object{
    public:
	ImgFreq(int nx_,int ny_);//nx si ny reprezinta dimensiunea imaginii in domeniul spatial (nu domeniul frecventa)
	ImgFreq();
	ImgFreq(std::string filename);
	~ImgFreq();
	ImgFreq(ImgFreq *other);
	
	void reset(int nx_,int ny_);
	
	inline void get(int fx,int fy,REALTYPE &c,REALTYPE &s){
	    if ((fx<-((nx+1)/2))||(fy<0)||(fx>=nx/2)||(fy>=ny/2+1)) {
	        c=0.0;
	        s=0.0;
	    }else{
		int X=(fy*nx+fx+nx/2+1)*2;
		c=data[X];
		s=data[X+1];
	    };
	};
	inline void get_interpolated(REALTYPE fx,REALTYPE fy,REALTYPE &c,REALTYPE &s){
	    if ((fx<-(nx/2))||(fy<0)||(fx>=nx/2-1)||(fy>=ny/2)) {
	        c=0.0;
	        s=0.0;
	    }else{
		int ifx=(int)(floor(fx));
		int ify=(int)(floor(fy));
		REALTYPE ffx=fx-floor(fx);
		REALTYPE ffy=fy-floor(fy);
		int XA=(ify*nx+ifx+nx/2+1)*2;
		int XB=((ify+1)*nx+ifx+nx/2+1)*2;
		c=(data[XA]*(1.0-ffx)+data[XA+2]*ffx)*(1.0-ffy)+(data[XB]*(1.0-ffx)+data[XB+2]*ffx)*ffy;
		s=(data[XA+1]*(1.0-ffx)+data[XA+3]*ffx)*(1.0-ffy)+(data[XA+1]*(1.0-ffx)+data[XA+3]*ffx)*ffy;
	    };
	};
	inline void set(int fx,int fy,REALTYPE c,REALTYPE s){
	    if ((fx<-((nx+1)/2))||(fy<0)||(fx>=nx/2)||(fy>=ny/2+1)) {
		return;
	    }else{
		int X=(fy*nx+fx+nx/2+1)*2;
		data[X]=c;
		data[X+1]=s;
	    };
	};
	REALTYPE get_max_amplitude();//returneaza amplitudinea maxima (sau 1e-8 daca este prea mica)

	int getnx(){return nx;};
	int getny(){return ny;};

	void debug();
	
    private:
	void savecustomdata(FILE *f);
	bool loadcustomdata(FILE *f);
	int nx,ny;
};


#endif
