/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <stdlib.h>
#include <stdio.h>
#include "Object.h"

#define FILE_VERSION 0

using namespace std;


Object::Object(){
    datasize=1;
    data=new REALTYPE[1];
    data[0]=0;
    info.asamplerate=44100;
    type=NONE;
};

Object::Object(Object &o){
};

void Object::copyfrom(Object *o){
    datasize=o->datasize;
    data=new REALTYPE[datasize];
    for (int i=0;i<datasize;i++) data[i]=o->data[i];
    type=o->type;
    copyinfofrom(o);
};

Object::~Object(){
    if (data) delete[]data;
    data=NULL;
};


void Object::setdatasize(int datasize_){
    datasize=datasize_;
    if (data) delete[]data;
    data=NULL;
    if (datasize){
	data=new REALTYPE[datasize+4];
	for (int i=0;i<datasize+4;i++) data[i]=0.0;
    };
};

bool Object::savefile(string filename){
    FILE *f=fopen(filename.c_str(),"w");
    if (!f) return (false);
    
    //salvez headerul
    int type=0x32493253;
    fwrite(&type,sizeof(type),1,f);

    //salvez versiunea
    int ver=FILE_VERSION;
    fwrite(&ver,sizeof(ver),1,f);

    //salvez data de catre obiect
    savecustomdata(f);

    //scriu marimea f loat-ului
    int rtsize=sizeof(REALTYPE);
    fwrite(&rtsize,sizeof(rtsize),1,f);

    //salvez marimea datelor
    fwrite(&datasize,sizeof(datasize),1,f);
    
    //salvez datele
    fwrite(data,sizeof(REALTYPE),datasize,f);
    
    fclose(f);
    return true;
};

bool Object::loadfile(std::string filename){
    FILE *f=fopen(filename.c_str(),"r");
    if (!f) return (false);
    
    //verific headerul
    int type=0;
    fread(&type,sizeof(type),1,f);
    if (type!=0x32493253) return false;
    
    //verific versiunea
    int ver=-1;
    fread(&ver,sizeof(ver),1,f);
    if (ver!=FILE_VERSION) return false;
    
    //salvez data de catre obiect
    if (!loadcustomdata(f)) return false;
    
    //verific marimea f loat-ului
    int rtsize;
    fread(&rtsize,sizeof(rtsize),1,f);
    if (rtsize!=sizeof(REALTYPE)) return false;

    
    setdatasize(0);
    //salvez marimea datelor
    fread(&datasize,sizeof(datasize),1,f);
    
    
    //todo: sa verific daca datasize e ok
    setdatasize(datasize);
    
    //salvez datele
    fread(data,sizeof(REALTYPE),datasize,f);

    fclose(f);
    return true;
};


void Object::copyinfofrom(Object *o){
    info=o->info;
};


Object::Type Object::get_type(){
    return type;
};



