/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef OBJECT_H
#define OBJECT_H
#include <string>
#include "../globals.h"

class Object{
    public:
	Object();

	~Object();
	enum Type{NONE,SND,IMG,SNDFREQ,IMGFREQ};

	bool savefile(std::string filename);
	bool loadfile(std::string filename);
	void copyfrom(Object *o);
	
	void copyinfofrom(Object *o);
	void info_set_samplerate(int samplerate){
	    info.asamplerate=samplerate;
	};
	int info_get_samplerate(){
	    return info.asamplerate;
	};

	Type get_type();

    protected:
	virtual void savecustomdata(FILE *f)=0;
	virtual bool loadcustomdata(FILE *f)=0;
	void setdatasize(int datasize_);
	REALTYPE *data;
	int datasize;
		
	struct{
	    int asamplerate;
	}info;
	
	Type type;
	
    private:	
	Object(Object &o);
};



#endif

