/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <stdio.h>
#include <math.h>
#include "Snd.h"
#include "../IO/AInput.h"
#include "../IO/AOutput.h"
#include "../IO/ImgOutput.h"

using namespace std;

Snd::Snd(int nx_):Object(){
    type=SND;
    nx=nx_;
    setdatasize(nx);
};
Snd::Snd():Object(){
    type=SND;
    nx=0;
};

Snd::Snd(string filename):Object(){
    type=SND;
    nx=0;
    loadfile(filename);
};

Snd::~Snd(){
};


void Snd::savecustomdata(FILE *f){
    int header=0x00646e53;
    fwrite(&header,4,1,f);
    
    fwrite(&nx,sizeof(nx),1,f);
};

bool Snd::loadcustomdata(FILE *f){
    int header=0x00646e53,h=0;
    fread(&h,4,1,f);
    if (h!=header) return false;
    
    
    fread(&nx,sizeof(nx),1,f);
    return true;
};

bool Snd::import_audio(std::string filename,int nchan,int audiosize){
    AInput in;
    if (in.open(filename)){
	info.asamplerate=in.info.samplerate;
	reset((audiosize>in.info.nsamples)?audiosize:in.info.nsamples);
	nchan%=in.info.nchannels;
	const int bufsize=1024;
	short int buffer[bufsize*in.info.nchannels];
	int current=0,part=0;
	for (int k=0;k<in.info.nsamples/bufsize+1;k++){
	    if (in.eof) break;
	    int bs=in.read(bufsize,buffer);
	    for (int i=0;i<bs;i++){
		set(current,buffer[i*in.info.nchannels+nchan]*0.000030517578124);
		current++;
	    };
	    part++;
	};
	return true;
    }else{
	nx=0;
	setdatasize(nx);
	return false;
    };
};

bool Snd::export_audio(std::string filename){
    AOutput out;
    if (out.newfile(filename,info.asamplerate)){
	REALTYPE max=0.0,x;
	for (int i=0;i<nx;i++){
	    x=fabs(data[i]);
	    if (max<x) max=x;
	};
	if (max<1e-7) max=1e-7;
	max=32767.0/max;
	
	const int bufsize=1024;
	short int buffer[bufsize];
	int current=0,part=0;
	for (int k=0;k<nx/bufsize+1;k++){
	    int bs=bufsize;
	    if ((nx-current)<bufsize) bs=nx-current;
	    if (bs>0){
		for (int i=0;i<bs;i++){
		    buffer[i]=(int)(get(current)*max);
		    current++;
		};
		out.write(bs,buffer);
	    };
	    part++;
	};
	return true;
    }else{
	return false;
    };
};


void Snd::debug(){
    if (getnx()>1000){
	printf( "Snd: DEBUG ERROR: nx=%d too big for debug\n",getnx());
	return;
    } else {
	printf( "Snd: DEBUG - nx=%d\n",getnx());
	for (int i=0;i<getnx();i++){
	    REALTYPE x=get(i);
	    printf("    [%d] = \t %10g \n",i,fabs(x)>0.00001?x:0);
	};
	printf( "\n\n");
    };
};

void Snd::debug2image(std::string filename){
    REALTYPE max=0.0;
    for (int i=0;i<nx;i++){
	REALTYPE x=fabs(data[i]);
	if (max<x) max=x;
    };
    if (max<1e-6) max=1e-6;
    const int xres=300;
    ImgOutput out(xres,nx);
    if (!out.newfile(filename)) return;
    unsigned char row[xres];
    for (int i=0;i<xres;i++) row[i]=255;
    int oldix,ix;
    for (int i=0;i<nx;i++){
	ix=(int)(xres*((data[i]/max*0.49)+0.5));
	if (i) row[oldix]=255;
	row[xres/2]=200;
	row[ix]=0;
	oldix=ix;
	out.writerow(row);
    };
    out.closefile();
};


