/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef SND_H
#define SND_H
#include "Object.h"

class Snd:public Object{
    public:
	Snd(int nx_);
	Snd();
	Snd(std::string filename);
	~Snd();
	bool import_audio(std::string filename,int nchan=0,int audiosize=0);
	bool export_audio(std::string filename);

	inline REALTYPE get(int x){
	    if ((x<0)||(x>=nx)) return 0.0;
	    return data[x];
	};
	inline void set(int x,REALTYPE val){
	    if ((x<0)||(x>=nx)) return;
	    data[x]=val;
	};
	int getnx(){return nx;};
	void reset(int nx_=0){
	    nx=nx_;
	    setdatasize(nx);
	};
	
	void debug();
	void debug2image(std::string filename);
    private:
	void savecustomdata(FILE *f);
	bool loadcustomdata(FILE *f);
	int nx;
};


#endif
