/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <stdio.h>
#include <math.h>
#include "../IO/AInput.h"
#include "../IO/AOutput.h"

#include "SndFreq.h"
using namespace std;

SndFreq::SndFreq(int nx_):Object(){
    type=SNDFREQ;
    nx=nx_;
    setdatasize(nx+2);
};

SndFreq::SndFreq():Object(){
    type=SNDFREQ;
    nx=0;
    setdatasize(2);
};

SndFreq::SndFreq(string filename):Object(){
    type=SNDFREQ;
    nx=0;
    loadfile(filename);
};

REALTYPE SndFreq::get_max_amplitude(){
    REALTYPE max_amplitude=0.0;
    for (int i=0;i<nx/2;i++){
	REALTYPE c,s;
	get(i,c,s);
	REALTYPE amp=sqrt(s*s+c*c);
	max_amplitude=max(max_amplitude,amp);
    };
    if (max_amplitude<1e-8) max_amplitude=1e-8;
    return max_amplitude;
};


void SndFreq::savecustomdata(FILE *f){
    int header=0x46646e53;
    fwrite(&header,4,1,f);
    
    fwrite(&nx,sizeof(nx),1,f);
};

bool SndFreq::loadcustomdata(FILE *f){
    int header=0x46646e53,h=0;
    fread(&h,4,1,f);
    if (h!=header) return false;    
    
    fread(&nx,sizeof(nx),1,f);
    return true;
};

void SndFreq::debug(){
    if (getnfreq()>500){
	printf( "SndFreq: DEBUG ERROR: nfreq=%d too big for debug\n",getnfreq());
	return;
    } else {
	printf( "SndFreq: DEBUG - nfreq=%d\n",getnfreq());
	for (int i=0;i<getnfreq();i++){
	    REALTYPE c,s;
	    get(i,c,s);
	    printf("    [%d] = \t %10g   %10g\n",i,fabs(c)>0.00001?c:0,fabs(s)>0.00001?s:0);
	};
	printf( "\n\n");
    };
};

