/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef SNDFREQ_H
#define SNDFREQ_H
#include "Object.h"

class SndFreq:public Object{
    public:
	SndFreq(int nx_);//numarul de sample-uri de la sunetul in domeniul timp
	SndFreq();
	SndFreq(std::string filename);
//	SndFreq(SndFreq *other);
	
	inline void get(int fx,REALTYPE &c,REALTYPE &s){//fx este frecventa 0..nx/2+1
	    if ((fx<0)||(fx>(nx/2+1))) {
		c=0.0;
		s=0.0;
	    } else{
	        c=data[fx*2];
	        s=data[fx*2+1];
	    };
	};
	inline void set(int fx,REALTYPE c,REALTYPE s){//fx este frecventa 0..nx/2+1
	    if ((fx<0)||(fx>(nx/2+1))) return;
	    data[fx*2]=c;
	    if (fx) data[fx*2+1]=s;
	};
	inline void add(int fx,REALTYPE c,REALTYPE s){//fx este frecventa 0..nx/2+1
	    if ((fx<0)||(fx>(nx/2+1))) return;
	    data[fx*2]+=c;
	    if (fx) data[fx*2+1]+=s;
	};

	int getnx(){return nx;};
	int getnfreq(){return (nx/2+1);};
	void reset(int nx_){//numarul de sample-uri de la sunetul in domeniul timp
	    nx=nx_;
	    setdatasize(nx+2);
	};
	
	void debug();
	REALTYPE get_max_amplitude();//returneaza amplitudinea maxima (sau 1e-8 daca este prea mica)
	
    private:
	void savecustomdata(FILE *f);
	bool loadcustomdata(FILE *f);
	int nx;
};



#endif
