/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <string>
#include <math.h>
#include "Par.h"
using namespace std;

Par::Par(string id,string name,int min,int max,int val,REALTYPE power){
    type=INT;
    enabled=true;
    int_pars.min=min;
    int_pars.max=max;
    int_pars.val=clamp(val,min,max);
    power=clamp(power,0.0,30.0);
    int_pars.power=pow(2.0,power*0.1);
    this->id=id;
    this->name=name;
};

Par::Par(string id,string name,string choices,int min, int max, int val){
    type=INTCOMBO;
    enabled=true;
    intcombo_pars.choices=choices;
    int_pars.val=val;
    int_pars.min=min;
    int_pars.max=max;
    int_pars.power=0.0;

    this->id=id;
    this->name=name;
};


Par::Par(string id,string name,REALTYPE min,REALTYPE max,REALTYPE val,REALmode mode,REALTYPE power){
    type=REAL;
    enabled=true;
    
    if (mode==EXP){
	if (max<1e-10) max=1e-10;
	if (min<1e-10) min=1e-10;
    };
    
    real_pars.min=min;
    real_pars.max=max;
    real_pars.val=clamp(val,min,max);
    real_pars.mode=mode;
    real_pars.power=pow(2.0,power*0.1);

    this->id=id;
    this->name=name;
};

Par::Par(string id,string name,string choices,REALTYPE min, REALTYPE max, REALTYPE val){
    type=REALCOMBO;
    enabled=true;
    intcombo_pars.choices=choices;
    real_pars.min=min;
    real_pars.max=max;
    real_pars.val=clamp(val,min,max);
    realcombo_pars.choices=choices;

    this->id=id;
    this->name=name;
};


Par::Par(string id,string name,string choices,string val){
    type=CHOICE;
    enabled=true;
    choice_pars.choices=choices;
    choice_pars.val=val;

    this->id=id;
    this->name=name;
};


Par::Par(string id,string name){
    type=SEPARATOR;
    enabled=true;

    this->id=id;
    this->name=name;
};

Par::Par(string id,string name,bool val){
    type=BOOL;
    enabled=true;
    
    bool_pars.val=val;

    this->id=id;
    this->name=name;
};


string Par::get_name(){
    return name;
};

string Par::get_id(){
    return id;
};

PARtype Par::get_type(){
    return type;
};

REALTYPE Par::get_value_for_slider(){
    REALTYPE x=0.5;
    if (type==INT){
	x=(int_pars.val-int_pars.min)/(REALTYPE)(int_pars.max-int_pars.min);
	x=pow(x,1.0/int_pars.power);
    };
    if (type==REAL){
	if (real_pars.mode==LINEAR){
	    x=(real_pars.val-real_pars.min)/(real_pars.max-real_pars.min);	    
	};
	if (real_pars.mode==EXP){
	    x=log(real_pars.val/real_pars.min)/log(real_pars.max/real_pars.min);
	};
	x=pow(x,1.0/real_pars.power);
    };
    
    return x;
};

void Par::set_value_from_slider(REALTYPE x){
    if (x<0.0) x=0.0;
	else if (x>1.0) x=1.0;
    if (type==INT){
	x=pow(x,int_pars.power);
	REALTYPE val=(int_pars.max-int_pars.min)*x+int_pars.min;
	int_pars.val=(int)val;
    };
    if (type==REAL){
	REALTYPE val=real_pars.min;
	x=pow(x,real_pars.power);
	if (real_pars.mode==LINEAR){
	    val=(real_pars.max-real_pars.min)*x+real_pars.min;
	};
	if (real_pars.mode==EXP){
	    val=exp(x*log(real_pars.max/real_pars.min))*real_pars.min;
	};
	real_pars.val=val;
    };
};

void Par::set_int_value(int value){
    if ((type==INT)||(type==INTCOMBO)) int_pars.val=clamp(value,int_pars.min,int_pars.max);
};

void Par::set_real_value(REALTYPE value){
    if ((type==REAL)||(type==REALCOMBO)) real_pars.val=clamp(value,real_pars.min,real_pars.max);
};
void Par::set_choice_value(string value){
    if (type==CHOICE) choice_pars.val=value;
};
void Par::set_bool_value(bool value){
    if (type==BOOL) bool_pars.val=value;
};


int Par::get_int_value(){
    if ((type!=INT)&&(type!=INTCOMBO)) return 0;
    return clamp((int)int_pars.val,int_pars.min,int_pars.max);
};

float Par::get_real_value(){
    if ((type!=REAL)&&(type!=REALCOMBO)) return 0.0;
    return clamp(real_pars.val,real_pars.min,real_pars.max);
};

string Par::get_choice_value(){
    if (type!=CHOICE) return "";
    return choice_pars.val;
};
bool Par::get_bool_value(){
    if (type!=BOOL) return false;
    return bool_pars.val;
};



