/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <string>
#include "../globals.h"

#ifndef PAR_H
#define PAR_H
enum REALmode{LINEAR,EXP};
enum PARtype{SEPARATOR,INT,INTCOMBO,REAL,REALCOMBO,CHOICE,BOOL,ENVELOPE};
class Par{
    friend class ParDialog;
    public:
	Par(std::string id,std::string name,int min,int max,int val,REALTYPE power);
	Par(std::string id,std::string name,std::string choices,int min, int max, int val);

	Par(std::string id,std::string name,REALTYPE min,REALTYPE max,REALTYPE val,REALmode mode,REALTYPE power=0.0);
	Par(std::string id,std::string name,std::string choices,REALTYPE min,REALTYPE max,REALTYPE val);

	Par(std::string id,std::string name,std::string choices,std::string val);// "choices" sunt separate de un "|"
	Par(std::string id,std::string name,bool val);
	Par(std::string id="",std::string name="");//este doar un separator    
	    
	

	std::string get_name();
	std::string get_id();
	PARtype get_type();

	int get_int_value();
	float get_real_value();
	std::string get_choice_value();
	bool get_bool_value();
	
	void set_int_value(int value);
	void set_real_value(REALTYPE value);
	void set_choice_value(std::string value);
	void set_bool_value(bool value);

	bool enabled;

    private:
	//obtine valoarea normalizata de la 0 la 1 pentru slider
	//valoare valida doar daca type=INT sau REAL
	REALTYPE get_value_for_slider();
	void set_value_from_slider(REALTYPE x);//x este intre 0 si 1
    
	std::string name,id;
	PARtype type;
	
	struct{
	    int val;
	    int min,max;
	    REALTYPE power;
	}int_pars;
	struct{
	    REALTYPE val;
	    REALTYPE min,max;
	    REALmode mode;
	    REALTYPE power;
	}real_pars;
	
	struct{
	    std::string choices;
	    std::string val;
	}choice_pars;
	
	struct{
	    std::string choices;
	}intcombo_pars;

	struct{
	    std::string choices;
	}realcombo_pars;

	struct{
	    bool val;
	}bool_pars;

};


#endif
