/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "Parameters.h"
#include <stdio.h>

using namespace std;

Parameters::Parameters(string id,string name){
    if (name=="") name=id;
    this->name=name;
    this->id=id;
};
Parameters::~Parameters(){
};

string Parameters::get_par_id(){
    return id;
};
string Parameters::get_par_name(){
    return name;
};

void Parameters::add_par_int(string id,string name,int min,int max,int val,REALTYPE power){
    pars.push_back(Par(id,name,min,max,val,power));
};
void Parameters::add_par_intcombo(string id,string name,string choices,int min,int max,int val){
    pars.push_back(Par(id,name,choices,min,max,val));
};

void Parameters::add_par_real(string id,string name,REALTYPE min,REALTYPE max,REALTYPE val,REALmode mode,REALTYPE power){
    pars.push_back(Par(id,name,min,max,val,mode,power));
};
void Parameters::add_par_realcombo(string id,string name,string choices,REALTYPE min,REALTYPE max,REALTYPE val){
    pars.push_back(Par(id,name,choices,min,max,val));
};

void Parameters::add_par_choice(string id,string name,string choices,string val){
    pars.push_back(Par(id,name,choices,val));
};
void Parameters::add_par_separator(string id,string name){
    pars.push_back(Par(id,name));
};
void Parameters::add_par_bool(string id,string name,bool val){
    pars.push_back(Par(id,name,val));
};



int Parameters::get_par_int(string id){
    list <Par>::iterator iter; 
    for (iter=pars.begin();iter!=pars.end();iter++){
	if (iter->get_id().c_str()==id){
	    return iter->get_int_value();
	};
    };
    return 0;
};

REALTYPE Parameters::get_par_real(string id){
    list <Par>::iterator iter; 
    for (iter=pars.begin();iter!=pars.end();iter++){
	if (iter->get_id().c_str()==id){
	    return iter->get_real_value();
	};
    };
    return 0.0;
};



string Parameters::get_par_choice(string id){
    list <Par>::iterator iter; 
    for (iter=pars.begin();iter!=pars.end();iter++){
	if (iter->get_id().c_str()==id){
	    return iter->get_choice_value();
	};
    };
    return "";
};

bool Parameters::get_par_bool(string id){
    list <Par>::iterator iter; 
    for (iter=pars.begin();iter!=pars.end();iter++){
	if (iter->get_id().c_str()==id){
	    return iter->get_bool_value();
	};
    };
    return false;
};


void Parameters::set_enabled_par(string id,bool enabled){
    list <Par>::iterator iter; 
    for (iter=pars.begin();iter!=pars.end();iter++){
	if (iter->get_id().c_str()==id){
	    iter->enabled=enabled;
	};
    };
};


