/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef PARAMETERS_H
#define PARAMETERS_H
#include <string>
#include <list>
#include "../globals.h"
#include "Par.h"

#define PAR_SAMPLERATE_CHOICES "11025|16000|22050|32000|44100|48000"


class Parameters{
    friend class ParametersDialog;
    public:
	Parameters(std::string id,std::string name);
	~Parameters();
	
	void add_par_int(std::string id,std::string name,int min,int max,int val,REALTYPE power=0.0);
	void add_par_intcombo(std::string id,std::string name,std::string choices,int min,int max,int val);
	void add_par_real(std::string id,std::string name,REALTYPE min,REALTYPE max,REALTYPE val,REALmode mode=LINEAR,REALTYPE power=0.0);
	void add_par_realcombo(std::string id,std::string name,std::string choices,REALTYPE min,REALTYPE max,REALTYPE val);
	void add_par_choice(std::string id,std::string name,std::string choices,std::string val);
	void add_par_separator(std::string id="",std::string name="");
	void add_par_bool(std::string id,std::string name,bool val);
	
	std::string get_par_id();
	std::string get_par_name();
	
	int get_par_int(std::string id);
	REALTYPE get_par_real(std::string id);
	std::string get_par_choice(std::string id);
	bool get_par_bool(std::string id);
	
	void set_enabled_par(std::string id,bool enabled);
	virtual bool update_parameters(std::string source_par){return false;};//actualizeaza unii parametrii in functie de alti parametrii; returneaza true daca trebuie actualizata toata interfata
    private:
	std::list <Par> pars;
	std::string id;
	std::string name;

};

#endif


