/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "StretchI.h"
#include <math.h>
#include "../../Generator/Random.h"
//started 2006-04-08  (20060407LD)

using namespace std;

StretchI::StretchI():Process("IMG_STRETCH","Stretch"){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);
    
    //add parameters
    add_par_choice("TYPE","Type","Stretch|Move|Rotate|Slant|Wobble","Stretch");
    add_par_real("AMOUNT","Amount",0.0,100.0,10.0,LINEAR,20.0);
    add_par_real("STRETCHX","X Stretch",0.1,10.0,1.0,EXP,10.0);
    add_par_real("STRETCHY","Y Stretch",0.1,10.0,1.0,EXP,10.0);
    add_par_real("MOVEX","X Move",-100,100.0,0.0,LINEAR,0);
    add_par_real("MOVEY","Y Move",-100,100.0,0.0,LINEAR,0);
    add_par_real("WOBBLEX","X Wobble",1.0,100.0,2.0,EXP,10.0);
    add_par_real("WOBBLEY","Y Wobble",1.0,100.0,2.0,EXP,10.0);
    add_par_real("PHASE","Phase",-PI,PI,0,LINEAR,0.0);
    add_par_real("ANGLE","ANGLE",-180.0,180.0,0,LINEAR,0.0);
    add_par_real("SLANTX","X Slant",-2.0,2.0,0.0,LINEAR,0.0);
    add_par_real("SLANTY","Y Slant",-2.0,2.0,0.0,LINEAR,0.0);

    update_parameters("");
};

Object::Type StretchI::get_input_type(int n){
    switch(n){
	case 0: return Object::IMG;
    };
    return Object::NONE;
};
Object::Type StretchI::get_output_type(int n){
    switch(n){
	case 0: return Object::IMG;
    };
    return Object::NONE;
};
bool StretchI::update_parameters(string source_par){
    string type=get_par_choice("TYPE");

    set_enabled_par("STRETCHX",(type=="Stretch"));
    set_enabled_par("STRETCHY",(type=="Stretch"));
    set_enabled_par("WOBBLEX",(type=="Wobble"));
    set_enabled_par("WOBBLEY",(type=="Wobble"));
    set_enabled_par("AMOUNT",(type=="Wobble"));
    set_enabled_par("PHASE",(type=="Wobble"));

    set_enabled_par("MOVEX",(type=="Move"));
    set_enabled_par("MOVEY",(type=="Move"));
    set_enabled_par("ANGLE",(type=="Rotate"));
    set_enabled_par("SLANTX",(type=="Slant"));
    set_enabled_par("SLANTY",(type=="Slant"));
    
    if (source_par=="TYPE") return true;	
	else return false;
};
bool StretchI::do_process(){
    Img *in=dynamic_cast<Img *>(inputs[0]);
    Img *output=dynamic_cast<Img *>(outputs[0]);
    Img *input=input;
    if (in==output) input=new Img(in);
    output->copyinfofrom(input);
    string typestr=get_par_choice("TYPE");
    type=STRETCH;
    stretchx=stretchy=amount=1.0;
    phase=0.0;
    movex=movey=0.0;
    wobblex=wobbley=1.0;
    slantx=slanty=angle=0.0;

    if (typestr=="Stretch") type=STRETCH;
    if (typestr=="Move") type=MOVE;
    if (typestr=="Rotate") type=ROTATE;
    if (typestr=="Wobble") type=WOBBLE;
    if (typestr=="Slant") type=SLANT;

    stretchx=1.0/get_par_real("STRETCHX");
    stretchy=1.0/get_par_real("STRETCHY");
    wobblex=get_par_real("WOBBLEX");
    wobbley=get_par_real("WOBBLEY");
    amount=get_par_real("AMOUNT");
    phase=get_par_real("PHASE");
    movex=get_par_real("MOVEX");
    movey=get_par_real("MOVEY");
    angle=get_par_real("ANGLE")/180.0*PI;
    slantx=get_par_real("SLANTX");slantx*=slantx*slantx;
    slanty=get_par_real("SLANTY");slanty*=slanty*slanty;

    stretch(input,output);

    if (in!=input) delete input;
    return true;
};


void StretchI::stretch(Img *img1,Img *img2){
    int nx=img1->getnx();
    int ny=img1->getny();
    if (img1!=img2) img2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;

    for (int jb=0;jb<ny;jb++){
	for (int ib=-nx+1;ib<nx;ib++){
	    REALTYPE c,s;
	    int i=ib-nx/2;
	    int j=jb-ny/2;
	    REALTYPE i0=i,j0=j;
	    REALTYPE x=i/(REALTYPE)nx;
	    REALTYPE y=j/(REALTYPE)ny;
	    switch (type){
		case MOVE:
		    i0=i+movex;
		    j0=j+movey;
		break;
		case STRETCH:
		    i0=i*stretchx;
		    j0=j*stretchy;
		    break;
		case WOBBLE:
		    i0=i+amount*sin(y*wobblex*2.0*PI+phase);
		    j0=j+amount*sin(x*wobbley*2.0*PI+phase);
		    break;
		case ROTATE:
		    i0=i*cos(angle)+j*sin(angle);
	    	    j0=j*cos(angle)-i*sin(angle);
		break;
		case SLANT:
		    i0=i+slantx*j;
		    j0=j+slanty*i;
		break;
	    };
	    

	    REALTYPE val=img1->get_interpolated(i0+nx/2,j0+ny/2);
	    img2->set(ib,jb,val);
	};
    };

};

	
