/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "AmplitudePhaseI.h"
#include <math.h>
#include "../../Generator/Random.h"

using namespace std;

AmplitudePhaseI::AmplitudePhaseI():Process("IMGFREQ_FILTER","Filter"){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);
    
    //add parameters
    add_par_choice("TYPE","Type","Power|AmplitudePhase|Amp1|Threshold","Power");
    add_par_real("POWER","Power",0.3,3.0,1.0,EXP,0.0);
    add_par_real("AMPPOWER","Amplitude Power",0.3,3.0,1.0,EXP,0.0);
    add_par_real("PHASEMUL","Phase Multiplier",0.3,3.0,1.0,EXP,0.0);

    add_par_real("THDB","Threshold (dB)",-80,0.0,-20.0,LINEAR,0.0);
    add_par_bool("THUP","Upper Mode",false);

    update_parameters("");
};

Object::Type AmplitudePhaseI::get_input_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
Object::Type AmplitudePhaseI::get_output_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
bool AmplitudePhaseI::update_parameters(string source_par){
    string type=get_par_choice("TYPE");
    bool typepower=false,typeampphase=false,typethreshold;
    if (type=="Power") typepower=true;
    if (type=="AmplitudePhase") typeampphase=true;
    if (type=="Threshold") typethreshold=true;

    set_enabled_par("POWER",typepower);
    set_enabled_par("AMPPOWER",typeampphase);
    set_enabled_par("PHASEMUL",typeampphase);
    set_enabled_par("THDB",typethreshold);
    set_enabled_par("THUP",typethreshold);

    if (source_par=="TYPE") return true;
	else return false;
};

bool AmplitudePhaseI::do_process(){

    ImgFreq *input=dynamic_cast<ImgFreq *>(inputs[0]);
    ImgFreq *output=dynamic_cast<ImgFreq *>(outputs[0]);
    output->copyinfofrom(input);

    string type=get_par_choice("TYPE");
    
    REALTYPE amp=1.0,phase=1.0;

    if (type=="Power"){
	amp=phase=get_par_real("POWER");
	amp_phase_modifier(input,output,amp,phase);
    };
    if (type=="AmplitudePhase"){
	amp=get_par_real("AMPPOWER");
	phase=get_par_real("PHASEMUL");
	amp_phase_modifier(input,output,amp,phase);
    };
    
    if (type=="Amp1") {
	amp=0.0;
	phase=1.0;
	amp_phase_modifier(input,output,amp,phase);
    };
    if (type=="Threshold") {
	threshold(input,output,dB2rap(get_par_real("THDB")),get_par_bool("THUP"));
    };
    
    return true;
};

void AmplitudePhaseI::amp_phase_modifier(ImgFreq *imgfreq1,ImgFreq *imgfreq2,REALTYPE amppower,REALTYPE phasemul){
    int nx=imgfreq1->getnx();
    int ny=imgfreq1->getny();
    if (imgfreq1!=imgfreq2) imgfreq2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;
    REALTYPE max_amplitude=imgfreq1->get_max_amplitude();

    for (int j=0;j<ny;j++){
	for (int i=0;i<nx;i++){
	    REALTYPE c,s;

	    imgfreq1->get(i,j,c,s);
	    REALTYPE phase=atan2(s,c);
    	    REALTYPE amp=sqrt(s*s+c*c);

	    amp=pow(amp/max_amplitude,amppower);
	    phase*=phasemul;
	    phase+=amp/max_amplitude;

	    c=amp*cos(phase);
	    s=amp*sin(phase);

	    imgfreq2->set(i,j,c,s);
	    if (i){
		imgfreq1->get(-i,j,c,s);
		REALTYPE phase=atan2(s,c);
    		REALTYPE amp=sqrt(s*s+c*c);

		amp=pow(amp/max_amplitude,amppower);
		phase*=phasemul;

		c=amp*cos(phase);
		s=amp*sin(phase);

		imgfreq2->set(-i,j,c,s);
	    };
	};
    };
};

void AmplitudePhaseI::threshold(ImgFreq *imgfreq1,ImgFreq *imgfreq2,REALTYPE thresh,bool upper){
    int nx=imgfreq1->getnx();
    int ny=imgfreq1->getny();
    if (imgfreq1!=imgfreq2) imgfreq2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;
    REALTYPE max_amplitude=imgfreq1->get_max_amplitude();

    for (int j=0;j<ny;j++){
	for (int i=0;i<nx;i++){
	    REALTYPE c,s;
	    REALTYPE a=1.0;

	    imgfreq1->get(i,j,c,s);
	    REALTYPE amp=sqrt(s*s+c*c)/max_amplitude;
	    if (upper&&(amp>thresh)) a=0.0;
	    if ((!upper)&&(amp<=thresh)) a=0.0;
	    imgfreq2->set(i,j,c*a,s*a);
	    if (i){
		a=1.0;
		imgfreq1->get(-i,j,c,s);
		REALTYPE amp=sqrt(s*s+c*c)/max_amplitude;
		if (upper&&(amp>thresh)) a=0.0;
		if ((!upper)&&(amp<=thresh)) a=0.0;
		imgfreq2->set(-i,j,c*a,s*a);
	    };
	};
    };
};
