/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "FilterI.h"
#include <math.h>
#include "../../Generator/Random.h"

using namespace std;

FilterI::FilterI():Process("IMGFREQ_FILTER","Filter"){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);
    
    //add parameters
    add_par_choice("TYPE","Type","Filter|KeepOnly","Filter");
    add_par_choice("FILTERTYPE","Filter Type","LowPass|HighPass|BPFSquare|BPFCorner|Sine|Circle","LowPass");
    add_par_real("FREQ1","Frequency1",0.001,1.0,0.02,EXP,10.0);
    add_par_real("FREQ2","Frequency2",0.001,1.0,0.05,EXP,10.0);
    add_par_real("FREQXY","X/Y Frequency",0.01,100.0,1.0,EXP,0.0);
    add_par_choice("KEEPTYPE","What","Positive|Negative","Positive");

    update_parameters("");
};

Object::Type FilterI::get_input_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
Object::Type FilterI::get_output_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
bool FilterI::update_parameters(string source_par){
    string type=get_par_choice("TYPE");
    string filtertype=get_par_choice("FILTERTYPE");
    bool filter=false;
    bool usefreq2=false;
    if (type=="Filter") filter=true;
    if ((filtertype=="BPFSquare")||(filtertype=="BPFCorner")) usefreq2=true;
    set_enabled_par("FILTERTYPE",filter);
    set_enabled_par("FREQ1",filter);
    set_enabled_par("FREQXY",filter);
    set_enabled_par("FREQ2",usefreq2&&filter);

    set_enabled_par("KEEPTYPE",type=="KeepOnly");

    if ((source_par=="TYPE")||(source_par=="FILTERTYPE")) return true;
	else return false;

};
bool FilterI::do_process(){

    ImgFreq *input=dynamic_cast<ImgFreq *>(inputs[0]);
    ImgFreq *output=dynamic_cast<ImgFreq *>(outputs[0]);
    output->copyinfofrom(input);
    string typestr=get_par_choice("TYPE");
    string filtertype=get_par_choice("FILTERTYPE");
    Type type=FILTER;
    FilterType ftype=LOWPASS;
    if (filtertype=="LowPass") ftype=LOWPASS;
    if (filtertype=="HighPass") ftype=HIGHPASS;
    if (filtertype=="Sine") ftype=SINE;
    if (filtertype=="Circle") ftype=CIRCLE;
    if (filtertype=="BPFCorner") ftype=BPFCORNER;
    if (filtertype=="BPFSquare") ftype=BPFSQUARE;
    if (typestr=="Filter") type=FILTER;
    if (typestr=="KeepOnly") type=KEEP;
    
    REALTYPE freq1=get_par_real("FREQ1");
    REALTYPE freqxy=sqrt(get_par_real("FREQXY"));

    REALTYPE freq2=get_par_real("FREQ2");

    REALTYPE freqx1=clamp(freq1/freqxy,1e-3,1.0);
    REALTYPE freqx2=clamp(freq2/freqxy,1e-3,1.0);
    REALTYPE freqy1=clamp(freq1*freqxy,1e-3,1.0);
    REALTYPE freqy2=clamp(freq2*freqxy,1e-3,1.0);
    
    
    string keepstr=get_par_choice("KEEPTYPE");
    KeepType keep=POSITIVE;
    if (keepstr=="Positive") keep=POSITIVE;
    if (keepstr=="Negative") keep=NEGATIVE;

    if (type==FILTER) filter(input,output,freqx1,freqy1,freqx2,freqy2,ftype);
    if (type==KEEP) keeponly(input,output,keep);

    return true;
};

void FilterI::filter(ImgFreq *imgfreq1,ImgFreq *imgfreq2,REALTYPE freqx1,REALTYPE freqy1,REALTYPE freqx2,REALTYPE freqy2,FilterType filtertype){
    int nx=imgfreq1->getnx();
    int ny=imgfreq1->getny();
    if (imgfreq1!=imgfreq2) imgfreq2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;
    if ((filtertype==BPFCORNER)||(filtertype==BPFSQUARE)){
	if (freqx1>freqx2) swap(freqx1,freqx2);
	if (freqy1>freqy2) swap(freqy1,freqy2);
    };

    for (int j=0;j<ny;j++){
	for (int i=0;i<nx;i++){
	    REALTYPE x=i*0.5/(REALTYPE)nx;
	    REALTYPE y=j*0.5/(REALTYPE)ny;
	    REALTYPE c,s;
	    REALTYPE a=1.0;
	    switch (filtertype){
		case LOWPASS:
		    if ((x>freqx1)||(y>freqy1)) a=0.0;
			else a=1.0;
		break;
		case HIGHPASS:
		    if ((x>freqx1)||(y>freqy1)) a=1.0;
			else a=0.0;
		break;
		case BPFSQUARE:
		    if ((x>freqx1)&&(y>freqy1)&&(x<=freqx2)&&(y<=freqy2)) a=1.0;
			else a=0.0;
		break;
		case BPFCORNER:
		    if ( ( ((x>freqx1)&&(x<=freqx2))||((y>freqy1)&&(y<=freqy2)) ) &&
		     (x<freqx2) && (y<freqy2)) a=1.0;
			else a=0.0;
		break;
		case SINE:
		    a=fabs(cos(x/freqx1*2.0*PI)+cos(y/freqy1*2.0*PI));
		break;
		case CIRCLE:
		    a=fabs(cos(sqrt(pow(x/freqx1*2.0,2.0)+pow(y/freqy1*2.0,2.0))));
		break;
	    };
		
	    
//	    if ((j%10==0)&&(i%10==0))printf("%g ",a);
	    imgfreq1->get(i,j,c,s);
	    imgfreq2->set(i,j,c*a,s*a);
	    if (i){
		imgfreq1->get(-i,j,c,s);
		imgfreq2->set(-i,j,c*a,s*a);
	    };
	};
	
//	if (j%10==0) printf("\n");
	
    };
};

void FilterI::keeponly(ImgFreq *imgfreq1,ImgFreq *imgfreq2,KeepType keeptype){
    int nx=imgfreq1->getnx();
    int ny=imgfreq1->getny();
    if (imgfreq1!=imgfreq2) imgfreq2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;

    for (int j=0;j<ny;j++){
	for (int i=0;i<nx;i++){
	    REALTYPE c,s;
	    REALTYPE a=1.0;

	    imgfreq1->get(i,j,c,s);
	    if (keeptype==POSITIVE) a=1.0;
		else a=0.0;
	    imgfreq2->set(i,j,c*a,s*a);
	    if (i){
		imgfreq1->get(-i,j,c,s);
		if (keeptype==NEGATIVE) a=1.0;
		else a=0.0;
		imgfreq2->set(-i,j,c*a,s*a);
	    };
	};
    };

};

	
