/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "PhaseChangeI.h"
#include <math.h>
#include "../../Generator/Random.h"

using namespace std;

PhaseChangeI::PhaseChangeI():Process("IMGFREQ_PHASECHANGE","Phase Modifier"){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);
    
    add_par_choice("TYPEPHASE","Change Type","Add|Multiply|Randomize|Amplitude|Reverse|Linear|Power","Add");
    //la phase (in functie de typephase)
    add_par_real("PHAMOUNTADD","Amount",-PI,PI,0.0,LINEAR,0.0);
    add_par_real("PHAMOUNTMUL","Amount",0.0,5.0,1.0,LINEAR,15.0);
    add_par_real("PHAMOUNTRAND","Amount",0.0,1.0,0.1,LINEAR,10.0);
    add_par_real("PHAMOUNTAMP","Amount",0.0,100.0,1.0,LINEAR,30.0);

    add_par_real("PHAMOUNTLIN","Amount",0.0,1.0,0.5,LINEAR,15.0);
    add_par_real("PHANGLELIN","Angle",-180.0,180.0,0.0,LINEAR,0.0);

    add_par_real("PHAMOUNTPOW","Amount",0.0,1.0,0.02,LINEAR,25.0);
    add_par_real("PHANGLEPOW","Angle",-180.0,180.0,0.0,LINEAR,0.0);
    add_par_real("PHPOWPOW","Power",1.0,5.0,1.0,LINEAR,0);
    
    //add parameters
    update_parameters("");
};

Object::Type PhaseChangeI::get_input_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
Object::Type PhaseChangeI::get_output_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
bool PhaseChangeI::update_parameters(string source_par){
    string phase_type_str=get_par_choice("TYPEPHASE");

    set_enabled_par("PHAMOUNTADD",(phase_type_str=="Add"));
    set_enabled_par("PHAMOUNTMUL",(phase_type_str=="Multiply"));
    set_enabled_par("PHAMOUNTRAND",(phase_type_str=="Randomize"));
    set_enabled_par("PHAMOUNTAMP",(phase_type_str=="Amplitude"));
    set_enabled_par("PHAMOUNTLIN",(phase_type_str=="Linear"));
    set_enabled_par("PHANGLELIN",(phase_type_str=="Linear"));
    set_enabled_par("PHAMOUNTPOW",(phase_type_str=="Power"));
    set_enabled_par("PHANGLEPOW",(phase_type_str=="Power"));
    set_enabled_par("PHPOWPOW",(phase_type_str=="Power"));

    if (source_par=="TYPEPHASE") return true;
	else return false;

};

bool PhaseChangeI::do_process(){

    ImgFreq *input=dynamic_cast<ImgFreq *>(inputs[0]);
    ImgFreq *output=dynamic_cast<ImgFreq *>(outputs[0]);
    output->copyinfofrom(input);

    string phase_type_str=get_par_choice("TYPEPHASE");
    PhaseChangeType phase_type;
    amount=amountx=amounty=powamount=1.0;

    if (phase_type_str=="Add") {
        phase_type=PHADD;
        amount=get_par_real("PHAMOUNTADD");
    };
    if (phase_type_str=="Multiply") {
        phase_type=PHMUL;
        amount=get_par_real("PHAMOUNTMUL");
    };
    if (phase_type_str=="Randomize") {
	phase_type=PHRAND;
	amount=get_par_real("PHAMOUNTRAND");
    };
    if (phase_type_str=="Amplitude") {
        phase_type=PHAMP;
        amount=get_par_real("PHAMOUNTAMP");
    };
    if (phase_type_str=="Reverse") {
        phase_type=PHREV;
    };
    if (phase_type_str=="Linear") {
        phase_type=PHLIN;
	REALTYPE angle=get_par_real("PHANGLELIN")/180*PI;
	REALTYPE a=get_par_real("PHAMOUNTLIN")*2.0*PI;
	amountx=a*sin(angle);
	amounty=a*cos(angle);
    };
    if (phase_type_str=="Power") {
        phase_type=PHPOW;
	powamount=get_par_real("PHPOWPOW");
	REALTYPE angle=get_par_real("PHANGLEPOW")/180*PI;
	REALTYPE a=get_par_real("PHAMOUNTPOW")*pow(100.0,powamount);
	amountx=a*sin(angle);
	amounty=a*cos(angle);
    };
    change_phase(input,output,phase_type);
    return true;
};


void PhaseChangeI::change_phase(ImgFreq *imgfreq1,ImgFreq *imgfreq2,PhaseChangeType type){
    int nx=imgfreq1->getnx();
    int ny=imgfreq1->getny();
    Random rand;
    if (imgfreq1!=imgfreq2) imgfreq2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;
    REALTYPE max_amplitude=imgfreq1->get_max_amplitude();

    for (int j=0;j<ny;j++){
	REALTYPE y=j/(REALTYPE)ny;
	for (int i=0;i<nx;i++){
	    REALTYPE x=i/(REALTYPE) nx;
	    REALTYPE c,s;

	    imgfreq1->get(i,j,c,s);
	    REALTYPE phase=atan2(s,c);
    	    REALTYPE amp=sqrt(s*s+c*c);

	    change_phase_one(type,phase,amp/max_amplitude,rand.get(),x,y,i,j);
	    
	    c=amp*cos(phase);
	    s=amp*sin(phase);

	    imgfreq2->set(i,j,c,s);
	    if (i){
		imgfreq1->get(-i,j,c,s);
		REALTYPE phase=atan2(s,c);
    		REALTYPE amp=sqrt(s*s+c*c);

		change_phase_one(type,phase,amp/max_amplitude,rand.get(),-x,y,-i,j);
		c=amp*cos(phase);
		s=amp*sin(phase);

		imgfreq2->set(-i,j,c,s);
	    };
	};
    };
};

