/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef PHASE_CHANGE_I_H
#define PHASE_CHANGE_I_H

#include "../../../Objects/ImgFreq.h"
#include "../../Process.h"
#include <math.h>

class PhaseChangeI:public Process{
    public:
	PhaseChangeI();

	Object::Type get_input_type(int n);
	Object::Type get_output_type(int n);
	
	bool update_parameters(std::string source_par);
    private:
	bool do_process();
	enum PhaseChangeType {PHADD,PHMUL,PHRAND,PHAMP,PHREV,PHLIN,PHPOW};
	void change_phase(ImgFreq *imgfreq1,ImgFreq *imgfreq2,PhaseChangeType type);
	
	REALTYPE amount,amountx,amounty,powamount;
	
	inline void change_phase_one(PhaseChangeType type,REALTYPE &phase,REALTYPE amp,REALTYPE rand,REALTYPE x,REALTYPE y,int i,int j){
	    switch (type){
    		case PHADD:
    	    	    phase+=amount;
		break;
		case PHMUL:
		    phase*=amount;
		break;
		case PHRAND:
	    	    phase+=(rand-0.5)*2.0*amount*2.0*PI;
		break;
		case PHAMP:
		    phase+=amp*amount*2.0*PI;
		break;
		case PHREV:
		    phase=-phase;
		break;
		case PHLIN:
		    phase+=amountx*i+amounty*j;
		break;
		case PHPOW:
		    phase+=amountx*i*pow(fabs(x),powamount)+amounty*j*pow(fabs(y),powamount);
		break;
	};
};

};

#endif

