/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "StretchIF.h"
#include <math.h>
#include "../../Generator/Random.h"

using namespace std;

StretchIF::StretchIF():Process("IMGFREQ_STRETCH","Stretch"){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);
    
    //add parameters
    add_par_choice("TYPE","Type","Stretch|Move|Rotate|Slant|Wobble","Stretch");
    add_par_real("AMOUNT","Amount",0.0,100.0,10.0,LINEAR,20.0);
    add_par_real("STRETCHX","X Stretch",0.01,100.0,1.0,EXP,10.0);
    add_par_real("STRETCHY","Y Stretch",0.01,100.0,1.0,EXP,10.0);
    add_par_real("MOVEX","X Move",-100,100.0,0.0,LINEAR,0);
    add_par_real("MOVEY","Y Move",-100,100.0,0.0,LINEAR,0);
    add_par_real("WOBBLEX","X Wobble",1.0,100.0,10.0,EXP,10.0);
    add_par_real("WOBBLEY","Y Wobble",1.0,100.0,10.0,EXP,10.0);
    add_par_real("PHASE","Phase",-PI,PI,0,LINEAR,0.0);
    add_par_real("ANGLE","ANGLE",-180.0,180.0,0,LINEAR,0.0);
    add_par_real("SLANTX","X Slant",-2.0,2.0,0.0,LINEAR,0.0);
    add_par_real("SLANTY","Y Slant",-2.0,2.0,0.0,LINEAR,0.0);

    update_parameters("");
};

Object::Type StretchIF::get_input_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
Object::Type StretchIF::get_output_type(int n){
    switch(n){
	case 0: return Object::IMGFREQ;
    };
    return Object::NONE;
};
bool StretchIF::update_parameters(string source_par){
    string type=get_par_choice("TYPE");

    set_enabled_par("STRETCHX",(type=="Stretch"));
    set_enabled_par("STRETCHY",(type=="Stretch"));
    set_enabled_par("WOBBLEX",(type=="Wobble"));
    set_enabled_par("WOBBLEY",(type=="Wobble"));
    set_enabled_par("AMOUNT",(type=="Wobble"));
    set_enabled_par("PHASE",(type=="Wobble"));

    set_enabled_par("MOVEX",(type=="Move"));
    set_enabled_par("MOVEY",(type=="Move"));
    set_enabled_par("ANGLE",(type=="Rotate"));
    set_enabled_par("SLANTX",(type=="Slant"));
    set_enabled_par("SLANTY",(type=="Slant"));
    
    if (source_par=="TYPE") return true;	
	else return false;
};
bool StretchIF::do_process(){
    ImgFreq *in=dynamic_cast<ImgFreq *>(inputs[0]);
    ImgFreq *output=dynamic_cast<ImgFreq *>(outputs[0]);
    ImgFreq *input=input;
    if (in==output) input=new ImgFreq(in);
    output->copyinfofrom(input);
    string typestr=get_par_choice("TYPE");
    type=STRETCH;
    stretchx=stretchy=amount=1.0;
    phase=0.0;
    movex=movey=0.0;
    slantx=slanty=angle=0.0;
    wobblex=wobbley=1.0;

    if (typestr=="Stretch") type=STRETCH;
    if (typestr=="Move") type=MOVE;
    if (typestr=="Rotate") type=ROTATE;
    if (typestr=="Wobble") type=WOBBLE;
    if (typestr=="Slant") type=SLANT;

    stretchx=get_par_real("STRETCHX");
    stretchy=get_par_real("STRETCHY");
    amount=get_par_real("AMOUNT");
    phase=get_par_real("PHASE");
    movex=get_par_real("MOVEX");
    movey=get_par_real("MOVEY");
    wobblex=get_par_real("WOBBLEX");
    wobbley=get_par_real("WOBBLEY");
    angle=get_par_real("ANGLE")/180.0*PI;
    slantx=get_par_real("SLANTX");slantx*=slantx*slantx;
    slanty=get_par_real("SLANTY");slanty*=slanty*slanty;

    stretch(input,output);

    if (in!=input) delete input;
    return true;
};


void StretchIF::stretch(ImgFreq *imgfreq1,ImgFreq *imgfreq2){
    int nx=imgfreq1->getnx();
    int ny=imgfreq1->getny();
    if (imgfreq1!=imgfreq2) imgfreq2->reset(nx,ny);
    if ((nx==0)||(ny==0)) return;

    for (int j=0;j<ny;j++){
	for (int i=-nx+1;i<nx;i++){
	    REALTYPE c,s;
	    REALTYPE i0=i,j0=j;
	    REALTYPE x=i/(REALTYPE)nx;
	    REALTYPE y=j/(REALTYPE)ny;
	    switch (type){
		case MOVE:
		    i0=i+movex;
		    j0=j+movey;
		break;
		case STRETCH:
		    i0=i*stretchx;
		    j0=j*stretchy;
		    break;
		case WOBBLE:
		    i0=i+amount*sin(y*wobblex*2.0*PI+phase);
		    j0=j+amount*sin(x*wobbley*2.0*PI+phase);
		    break;
		case ROTATE:
		    i0=i*cos(angle)+j*sin(angle);
	    	    j0=j*cos(angle)-i*sin(angle);
		break;
		case SLANT:
		    i0=i+slantx*j;
		    j0=j+slanty*i;
		break;
	    };
	    

	    imgfreq1->get_interpolated(i0,j0,c,s);
	    imgfreq2->set(i,j,c,s);
	};
    };

};

	
