/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef AMPLITUDE_PHASES_H
#define AMPLITUDE_PHASES_H

#include "../../../Objects/SndFreq.h"
#include "../../Process.h"

class AmplitudePhaseS:public Process{
    public:
	AmplitudePhaseS();

	Object::Type get_input_type(int n);
	Object::Type get_output_type(int n);
	
	bool update_parameters(std::string source_par);
    private:
	bool do_process();
	void amp_phase_modifier(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE amppower,REALTYPE phasemul);
	void set_amp_to_1(SndFreq *sndfreq1,SndFreq *sndfreq2);
	void threshold(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE thresh,bool upper);

};

#endif

