/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef FILTER_S_H
#define FILTER_S_H

#include "../../../Objects/SndFreq.h"
#include "../../Process.h"

class FilterS:public Process{
    public:
	FilterS();
	Object::Type get_input_type(int n);
	Object::Type get_output_type(int n);
	
	bool update_parameters(std::string source_par);
    private:
	bool do_process();
	
	void lpf(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE freq,REALTYPE smooth=1.0);
	void hpf(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE freq,REALTYPE smooth=1.0);
	void bpf(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE freq1,REALTYPE freq2,REALTYPE smooth=1.0);
	void bsf(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE freq1,REALTYPE freq2,REALTYPE smooth=1.0);
	void filter(SndFreq *sndfreq1,SndFreq *sndfreq2,bool invertamp,REALTYPE freq1,REALTYPE freq2,REALTYPE smooth);
	
	void combf(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE freq,REALTYPE strength=0.0,REALTYPE phase=0.0,REALTYPE stretch=0.0);
	
	void bandwidthf(SndFreq *sndfreq1,SndFreq *sndfreq2,REALTYPE freq,REALTYPE bandwidth,int nharmonics,bool gauss);
	REALTYPE profile(REALTYPE fi, REALTYPE bwi);
    
};



#endif

