/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef PHASE_CHANGE_H
#define PHASE_CHANGE_H

#include "../../../Objects/SndFreq.h"
#include "../../Process.h"

class PhaseChangeS:public Process{
    public:
	PhaseChangeS();

	Object::Type get_input_type(int n);
	Object::Type get_output_type(int n);
	
	bool update_parameters(std::string source_par);
    private:
	bool do_process();
	enum PhaseChangeType {PHADD,PHMUL,PHRAND,PHAMP,PHREV};
	enum GroupDelayChangeType {GDADD,GDRAND,GDAMP,GDLIN,GDNONLINSQR,GDNONLINSIN};

	void change_phase(SndFreq *sndfreq1,SndFreq *sndfreq2,PhaseChangeType type,REALTYPE amount);
	void change_groupdelay(SndFreq *sndfreq1,SndFreq *sndfreq2,GroupDelayChangeType type,REALTYPE amount,REALTYPE freq);
};

#endif

