/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "TranslateS.h"
#include <math.h>
using namespace std;

TranslateS::TranslateS():Process("SNDFREQ_TRANSLATE","Spectrum Translate"){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);
    
    //add parameters
    add_par_choice("TYPE","Type","ShiftUp|ShiftDown|Mirror|MirrorAll","ShiftUp");
    add_par_real("FREQ1","Frequency (Hz)",0.01,22050,500,LINEAR,20.0);
    add_par_real("FREQ2","Frequency (Hz)",0.01,22050,2000,LINEAR,20.0);

};

Object::Type TranslateS::get_input_type(int n){
    switch(n){
	case 0: return Object::SNDFREQ;
    };
    return Object::NONE;
};
Object::Type TranslateS::get_output_type(int n){
    switch(n){
	case 0: return Object::SNDFREQ;
    };
    return Object::NONE;
};

bool TranslateS::update_parameters(string source_par){
    string type=get_par_choice("TYPE");
    set_enabled_par("FREQ2",(type.find("Mirror")!=-1));

    if (source_par=="TYPE") return true;
	else return false;
};


bool TranslateS::do_process(){
    string type=get_par_choice("TYPE");

    SndFreq *input=dynamic_cast<SndFreq *>(inputs[0]);
    SndFreq *output=dynamic_cast<SndFreq *>(outputs[0]);
    output->copyinfofrom(input);

    REALTYPE freq1=get_par_real("FREQ1");
    REALTYPE freq2=get_par_real("FREQ2");
    
    int ifreq1=(int)(freq1/input->info_get_samplerate()*input->getnx());
    int ifreq2=(int)(freq2/input->info_get_samplerate()*input->getnx());
    if (type=="ShiftUp"){
	shiftup(input,output,ifreq1);
    };
    if (type=="ShiftDown"){
	shiftdown(input,output,ifreq1);
    };
    if (type=="Mirror"){
	mirror(input,output,ifreq1,ifreq2);
    };
    if (type=="MirrorAll"){
	mirrorall(input,output,ifreq1,ifreq2);
    };

    return true;
};

void TranslateS::shiftdown(SndFreq *sndfreq1,SndFreq *sndfreq2,int ifreq){
    REALTYPE c,s;
    int n=sndfreq1->getnx();
    if (sndfreq1!=sndfreq2) sndfreq2->reset(n);
    for (int i=0;i<n/2;i++){
	sndfreq1->get(i+ifreq,c,s);
	sndfreq2->set(i,c,s);
    };
};
void TranslateS::shiftup(SndFreq *sndfreq1,SndFreq *sndfreq2,int ifreq){
    REALTYPE c,s;
    int n=sndfreq1->getnx();
    if (sndfreq1!=sndfreq2) sndfreq2->reset(n);
    for (int i=n/2-1;i>=0;i--){
	sndfreq1->get(i-ifreq,c,s);
	sndfreq2->set(i,c,s);
    };
};
void TranslateS::mirror(SndFreq *sndfreq1,SndFreq *sndfreq2,int ifreq1,int ifreq2){
    if (ifreq1>ifreq2) swap(ifreq1,ifreq2);
    int dist=ifreq2-ifreq1;
    if (dist<2) return;
    
    int n=sndfreq1->getnx()/2;
    if (sndfreq1!=sndfreq2) {
	sndfreq2->reset(n);
	REALTYPE c,s;
	for (int i=0;i<ifreq1;i++){
    	    sndfreq1->get(i,c,s);
    	    sndfreq2->set(i,c,s);
	};
	for (int i=ifreq2;i<n/2;i++){
    	    sndfreq1->get(i,c,s);
    	    sndfreq2->set(i,c,s);
	};
    } else {
	dist/=2;
    };
    REALTYPE c1,c2,s1,s2;
    for (int i=0;i<dist;i++){
        sndfreq1->get(ifreq1+i,c1,s1);
        sndfreq1->get(ifreq2-i,c2,s2);
        sndfreq2->set(ifreq2-i,c1,-s1);
        sndfreq2->set(ifreq1+i,c2,-s2);
    };
};

void TranslateS::mirrorall(SndFreq *sndfreq1,SndFreq *sndfreq2,int ifreq1,int ifreq2){
    if (ifreq1>ifreq2) swap(ifreq1,ifreq2);
    int delta=ifreq2-ifreq1;
    if (delta<2) return;
    
    int n=sndfreq1->getnx();
    if (sndfreq1!=sndfreq2) {
	sndfreq2->reset(n);
    };
    
    for (int j=-1;j<(n/(2*delta));j++){
	int if1=ifreq1%delta+j*delta;
	if1=clamp(if1,0,n/2);
	int if2=ifreq1%delta+(j+1)*delta;
	if2=clamp(if2,0,n/2);

	int dist=if2-if1;
	if (sndfreq1==sndfreq2) dist/=2;
	if (dist<2) continue;

	REALTYPE c1,c2,s1,s2;
	for (int i=0;i<dist;i++){
    	    sndfreq1->get(if1+i,c1,s1);
    	    sndfreq1->get(if2-i,c2,s2);
    	    sndfreq2->set(if2-i,c1,-s1);
    	    sndfreq2->set(if1+i,c2,-s2);
	};
    };
};

