/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef RANDOM_H
#define RANDOM_H
#include "../../Objects/Object.h"


class Random{
    public:
	Random();
	Random(unsigned int seed);
	inline REALTYPE get(){//get random numbers between 0..1
	    return(get32bits()*2.328306436538696289e-10);//1/(2**32)
	};
	inline REALTYPE get1(){//get random numbers between -1..1
	    return((get32bits()*4.660615075301634622e-10)-1.0);
	};
    private:
	inline unsigned int get32bits(){
	    s0=(s0*1103515245+12345)&0xFFFFFFFF;
	    s1=(((s1&0xFFFFFFFE)<<12)^(((s1<<13)^s1)>>19))&0xFFFFFFFF;
	    s2=(((s2&0xFFFFFFF8)<<4)^(((s2<<2)^s2)>>25))&0xFFFFFFFF;
	    s3=(0x10^((s3&0xFFFFFFF0)<<17)^(((s3<<3)^s3)>>11))&0xFFFFFFFF;
	    unsigned result=((s0<<16)|(s0>>16))^s1^s2^s3;
	};
    
	unsigned int s0,s1,s2,s3;
};

extern Random rnd;

#endif
