/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <math.h>
#include "ExpdecayGen.h"
#include "../Random.h"


ExpdecayGen::ExpdecayGen():Process("SND_EXPDECAY_GEN","Exponential Decay Generator"){
    //add inputs/outputs
    set_n_inputs(0);
    set_n_outputs(1);
    
    add_par_real("DECAY","Decay time (s)",0.001,900.0,1.0,EXP,-10.0);
    add_par_real("DAMP","High Frequency Damp",0.0,10.0,1.0,LINEAR,10.0);
    add_par_real("DAMPSTART","High Freq. Damp Start",0.01,1.0,1.0,LINEAR,10.0);
    add_par_separator();
    add_par_realcombo("DURATION","Duration (s)","0.5|1.0|2.0|5.0|10.0|30.0",0.01,1800.0,2.0);
    add_par_realcombo("DELAY","Delay (s)","0.0|0.1|0.5|1.0|10.0",0.0,1000.0,0.0);
    add_par_intcombo("SAMPLERATE","Sample Rate",PAR_SAMPLERATE_CHOICES,4000,96000,44100); 
};

ExpdecayGen::~ExpdecayGen(){
};

Object::Type ExpdecayGen::get_input_type(int n){
    return Object::NONE;
};
Object::Type ExpdecayGen::get_output_type(int n){
    switch(n){
	case 0: return Object::SND;
    };
    return Object::NONE;
};

bool ExpdecayGen::do_process(){
    REALTYPE decay=get_par_real("DECAY");
    REALTYPE damp=get_par_real("DAMP");
    REALTYPE dampstart=get_par_real("DAMPSTART");
    REALTYPE duration=get_par_real("DURATION");
    REALTYPE delay=get_par_real("DELAY");
    int samplerate=get_par_int("SAMPLERATE");    
    Snd *output=dynamic_cast<Snd *>(outputs[0]);
    generate(output,(int)(duration*samplerate),samplerate,decay,damp,dampstart,delay);

    
    return true;
};


void ExpdecayGen::generate(Snd *snd, int nx,int samplerate,REALTYPE decaytime, REALTYPE damp,REALTYPE dampstart, REALTYPE delay){
    snd->reset(nx);
    snd->info_set_samplerate(samplerate);
    REALTYPE x2=0.0,x3=0.0,x4=0.0;
    for (int i=0;i<nx;i++){
	REALTYPE t=i/(REALTYPE)samplerate-delay;
	if (t<0.0) {
	    snd->set(i,0.0);
	    continue;
	};
	REALTYPE amp=pow(0.001,t/decaytime);
	REALTYPE x1=(rnd.get()*2.0-1.0)*amp;
	REALTYPE alpha=pow(0.001,sqrt(t/decaytime*damp))*dampstart;
	
//	alpha*=(cos(t*6.28)+1.0)*0.5;//experiment
	
	
	x2=x2*(1.0-alpha)+x1*alpha;
	x3=x3*(1.0-alpha)+x2*alpha;
	x4=x4*(1.0-alpha)+x3*alpha;

	snd->set(i,x4);
    };

};


