/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <math.h>
#include <stdlib.h>
#include "PADsynthGen.h"
#include "../Random.h"

PADsynthGen::PADsynthGen():Process("SNDFREQ_PADsynth_GEN","PADsynth Generator"){
    //add inputs/outputs
    set_n_inputs(0);
    set_n_outputs(1);
    
    //add parameters
      add_par_real("FREQ","Base Frequency (Hz)",1.0,10000.0,220.0,LINEAR,20.0);
      add_par_real("BANDWIDTH", "Bandwidth (cents)",2.0,1000.0,30.0,EXP,-10);
      add_par_int("NHARMONICS","Number of harmonics(overtones)",1,512,40,20.0);
      add_par_real("HDAMP","Damp Higher Frequencies",0.0,4.0,1.0);
    
      add_par_separator();
	
      add_par_real("BWSCALE", "Bandwidth scaling",-1.0,2.0,1.0,LINEAR);
      add_par_real("FREQDETUNE","Frequency detuning",-10.0,20.0,0.0,LINEAR);
      add_par_intcombo("SAMPLES","Samples","32768|65536|131072|262144|524288|1048576",128,1048576*128,262144);
      add_par_intcombo("SAMPLERATE","Sample Rate",PAR_SAMPLERATE_CHOICES,4000,96000,44100); 
};

PADsynthGen::~PADsynthGen(){
};


Object::Type PADsynthGen::get_input_type(int n){
    return Object::NONE;
};
Object::Type PADsynthGen::get_output_type(int n){
    switch(n){
	case 0: return Object::SNDFREQ;
    };
    return Object::NONE;
};

bool PADsynthGen::do_process(){
     int samples=get_par_int("SAMPLES");
     int samplerate=get_par_int("SAMPLERATE");
     int nharmonics=get_par_int("NHARMONICS");
     REALTYPE hdamp=get_par_real("HDAMP");
     REALTYPE freq=get_par_real("FREQ");
     REALTYPE bandwidth=get_par_real("BANDWIDTH");
     REALTYPE bwscale=get_par_real("BWSCALE");
     REALTYPE freqdetune=get_par_real("FREQDETUNE");

     SndFreq *output=dynamic_cast<SndFreq *>(outputs[0]);

     
     generate(output,samples,samplerate,nharmonics,hdamp,freq,bandwidth,bwscale,freqdetune);

    return true;
};


REALTYPE PADsynthGen::profile(REALTYPE fi, REALTYPE bwi){
    REALTYPE x=fi/bwi;
    x*=x;
    if (x>14.71280603) return 0.0;
    return exp(-x)/bwi;
};


void PADsynthGen::generate(SndFreq *sndfreq,int nx,int samplerate,int nharmonics,REALTYPE hdamp,
	REALTYPE f,REALTYPE bw,REALTYPE bwscale,REALTYPE freqdetune){
    if (bw<0.01) bw=0.01;
    if (nharmonics<1) nharmonics=1;
    sndfreq->reset(nx);
    sndfreq->info_set_samplerate(samplerate);
    for (int nh=1;nh<=nharmonics;nh++){//for each harmonic
	REALTYPE bw_Hz;//bandwidth of the current harmonic measured in Hz
        REALTYPE bwi;
	REALTYPE fi;
	REALTYPE rF=f*pow(nh,pow(2.0,freqdetune/10));
	if (rF>=nx/2) break;

        bw_Hz=(pow(2.0,bw/1200.0)-1.0)*f*pow(rF/f,bwscale);
	bwi=bw_Hz/(2.0*samplerate);
	fi=rF/samplerate;

	REALTYPE h=pow(2.0,-(nh-1)*hdamp/10.0);
	REALTYPE sum=0.0;
	REALTYPE max=0.0;
	for (int i=1;i<nx/2;i++){
	    REALTYPE hprofile;
	    hprofile=profile((i/(REALTYPE)nx)-fi,bwi);
	    sndfreq->add(i,hprofile*h,0);
	    if (max<hprofile) max=hprofile;
	    sum+=hprofile;
	};
    };

    for (int i=0;i<nx/2;i++){
	REALTYPE phase=rnd.get()*2.0*PI;
	REALTYPE amp,tmp;
	sndfreq->get(i,amp,tmp);
	sndfreq->set(i,amp*cos(phase),amp*sin(phase));
    };

};


