/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "MapFractal.h"
#include <math.h>
using namespace std;

MapFractal::MapFractal(Mapping::MappingMode mappingmode):Mapping("MAP_FRACTAL","Fractal Mapping",mappingmode){
    for (int i=0;i<9;i++) peanomodes[i]=false;
    add_par_choice("DIRECTION","Direction","Horizontal|Vertical","Horizontal");
    add_par_choice("MODE","Mode","Hilbert|Peano","Hilbert");
    add_par_int("PEANOMAPPING","Peano Mapping No.",0,511,0);
/*
    vertical=false;
//    mode=Hilbert;
    mode=Peano;
//    peanomodes[0]=true;
*/
};
MapFractal::~MapFractal(){
};

bool MapFractal::update_parameters(string source_par){
    set_enabled_par("PEANOMAPPING",(get_par_choice("MODE")=="Peano"));
    if (source_par=="MODE") return true;
    return false;
};


void MapFractal::fixsize(int &nx,int &ny){
    if (mode==Hilbert){
	int size=max(nx,ny);
	float x=(int)(log(size)/log(2.0)+0.5);
	size=(int)pow(2.0,x);
		
	nx=size;
	ny=size;
    };
    if (mode==Peano){
	int size=max(nx,ny);
	float x=(int)(log(size)/log(3.0)+0.5);
	size=(int)pow(3.0,x);
		
	nx=size;
	ny=size;
    };
};


void MapFractal::do_map(int nx,int ny){
    vertical=(get_par_choice("DIRECTION")=="Vertical");
    if (get_par_choice("MODE")=="Hilbert") mode=Hilbert;
	else mode=Peano;
    int peanomapping=get_par_int("PEANOMAPPING");
    
    if (mode==Hilbert) do_map_hilbert(0,0,nx,0,0,ny,nx);
    if (mode==Peano) {
	for (int i=0,m=1;i<9;i++,m*=2) peanomodes[i]=((m&peanomapping)!=0);
	do_map_peano(0,0,0,0,nx,false);
    };
};

void MapFractal::do_map_hilbert(int x0,int y0,int xis,int xjs,int yis,int yjs,int level){
    if (level<=1){
	int x=x0+(xis+yis-1)/2;
	int y=y0+(xjs+yjs-1)/2;
	if (vertical) do_map_once(y,x);
	    else do_map_once(x,y);
    }else{
	level/=2;
	xis/=2;yis/=2;xjs/=2;yjs/=2;
	do_map_hilbert(x0, y0, yis, yjs, xis, xjs,level);
	do_map_hilbert(x0+xis, y0+xjs ,xis, xjs, yis, yjs,level);
	do_map_hilbert(x0+xis+yis, y0+xjs+yjs, xis, xjs, yis, yjs,level);
	do_map_hilbert(x0+xis+yis*2, y0+xjs+yjs*2, -yis,-yjs, -xis, -xjs,level);
	
    };
};


void MapFractal::do_map_peano(int x0,int y0,int xm,int ym,int n,bool v){
    if (n<=1){
	if (vertical) do_map_once(x0,y0);
	    else do_map_once(y0,x0);
    }else{
	n/=3;
	if (v){
	    do_map_peano(x0+2*xm*n,y0+2*ym*n,xm,ym,n,v^peanomodes[0]);
	    do_map_peano(x0+2*xm*n,y0+n,1-xm,ym,n,v^peanomodes[1]);
	    do_map_peano(x0+2*xm*n,y0+2*(1-ym)*n,xm,ym,n,v^peanomodes[2]);
    
	    do_map_peano(x0+n,y0+2*(1-ym)*n,xm,1-ym,n,v^peanomodes[3]);
	    do_map_peano(x0+n,y0+n,1-xm,1-ym,n,v^peanomodes[4]);
	    do_map_peano(x0+n,y0+2*ym*n,xm,1-ym,n,v^peanomodes[5]);

	    do_map_peano(x0+2*(1-xm)*n,y0+2*ym*n,xm,ym,n,v^peanomodes[6]);
	    do_map_peano(x0+2*(1-xm)*n,y0+n,1-xm,ym,n,v^peanomodes[7]);
	    do_map_peano(x0+2*(1-xm)*n,y0+2*(1-ym)*n,xm,ym,n,v^peanomodes[8]);
	}else{
	    do_map_peano(x0+2*xm*n,y0+2*ym*n,xm,ym,n,v^peanomodes[0]);
	    do_map_peano(x0+n,y0+2*ym*n,xm,1-ym,n,v^peanomodes[1]);
	    do_map_peano(x0+2*(1-xm)*n,y0+2*ym*n,xm,ym,n,v^peanomodes[2]);

	    do_map_peano(x0+2*(1-xm)*n,y0+n,1-xm,ym,n,v^peanomodes[3]);
	    do_map_peano(x0+n,y0+n,1-xm,1-ym,n,v^peanomodes[4]);
	    do_map_peano(x0+2*xm*n,y0+n,1-xm,ym,n,v^peanomodes[5]);

	    do_map_peano(x0+2*xm*n,y0+2*(1-ym)*n,xm,ym,n,v^peanomodes[6]);
	    do_map_peano(x0+n,y0+2*(1-ym)*n,xm,1-ym,n,v^peanomodes[7]);
	    do_map_peano(x0+2*(1-xm)*n,y0+2*(1-ym)*n,xm,ym,n,v^peanomodes[8]);
	};
    };
};

/*
void MapFractal::do_map_peano(int x0,int y0,int xm,int ym,int n){
    if (n<=1){
	if (vertical) do_map_once(x0,y0);
	    else do_map_once(y0,x0);
    }else{
	n/=3;
	do_map_peano(x0+2*xm*n,y0+2*ym*n,xm,ym,n);
	do_map_peano(x0+2*xm*n,y0+n,1-xm,ym,n);
	do_map_peano(x0+2*xm*n,y0+2*(1-ym)*n,xm,ym,n);
    
	do_map_peano(x0+n,y0+2*(1-ym)*n,xm,1-ym,n);
	do_map_peano(x0+n,y0+n,1-xm,1-ym,n);
	do_map_peano(x0+n,y0+2*ym*n,xm,1-ym,n);

	do_map_peano(x0+2*(1-xm)*n,y0+2*ym*n,xm,ym,n);
	do_map_peano(x0+2*(1-xm)*n,y0+n,1-xm,ym,n);
	do_map_peano(x0+2*(1-xm)*n,y0+2*(1-ym)*n,xm,ym,n);
    };
};

*/


