/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef MAP_FRACTAL_H
#define MAP_FRACTAL_H
#include "Mapping.h"
class MapFractal:public Mapping{
    public:
	MapFractal(Mapping::MappingMode mappingmode);
	~MapFractal();
	enum Mode{
	    Hilbert,Peano
	};
    private:
	bool update_parameters(std::string source_par);

	void do_map(int nx,int ny);
	void do_map_hilbert(int x0,int y0,int xis,int xjs,int yis,int yjs,int level);
	void do_map_peano(int x0,int y0,int xm,int ym,int n,bool v);
	
	void fixsize(int &nx,int &ny);
	
	bool vertical;
	Mode mode;
	bool peanomodes[9];

};


#endif



