/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "MapScanning.h"

MapScanning::MapScanning(Mapping::MappingMode mappingmode):Mapping("MAP_SCANNING","Scan Mapping",mappingmode){
    add_par_choice("DIRECTION","Direction","Horizontal|Vertical","Horizontal");
    add_par_choice("ALTERNATIVE","Alternative mode","No|Yes","Yes");
    add_par_choice("MODE","Mode","Linear|Square","Square");
    
};
MapScanning::~MapScanning(){
};

void MapScanning::do_map(int nx,int ny){
    vertical=(get_par_choice("DIRECTION")=="Vertical");
    alternative=(get_par_choice("ALTERNATIVE")=="Yes");
    square=(get_par_choice("MODE")=="Square");

    if (square) do_map_square(nx,ny);
	else do_map_linear(nx,ny);
};

void MapScanning::do_map_linear(int nx,int ny){
    bool inverse=false;
    if (vertical){
	for (int i=0;i<nx;i++){
	    for (int j=0;j<ny;j++){
		if (inverse){
		    do_map_once(i,ny-j-1);
		} else{
		    do_map_once(i,j);
		};
	    };
	    if (alternative) inverse=!inverse;
	};
    }else{
	for (int j=0;j<ny;j++){
	    for (int i=0;i<nx;i++){
		if (inverse){
		    do_map_once(nx-i-1,j);
		} else{
		    do_map_once(i,j);
		};
	    };
	    if (alternative) inverse=!inverse;
	};
    };
};    
    

void MapScanning::do_map_square(int nx,int ny){
    bool inverse=vertical;

    for (int m=0;m<min(nx,ny);m++){
	for (int i=0;i<m;i++){
	    if (inverse) do_map_once(i,m);
		else do_map_once(m,i);
	};
	do_map_once(m,m);
	for (int i=0;i<m;i++){
	    if (inverse) do_map_once(m,m-i-1);
		else do_map_once(m-i-1,m);
	};
	if (alternative) inverse=!inverse;
    };

    if (nx>ny){
	for (int i=0;i<(nx-ny);i++){
	    for (int j=0;j<ny;j++){
		if (inverse) do_map_once(i+ny,ny-j-1);
		    else do_map_once(i+ny,j);
	    };
	    if (alternative) inverse=!inverse;
	};
    };
    
    if (ny>nx){
	for (int i=0;i<(ny-nx);i++){
	    for (int j=0;j<nx;j++){
		if (inverse) do_map_once(j,i+nx);
		    else do_map_once(nx-j-1,i+nx);
	    };
	    if (alternative) inverse=!inverse;
	};
    };

};




