/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "MapZigzag.h"
#include "../../globals.h"
#include <math.h>
using namespace std;

MapZigzag::MapZigzag(Mapping::MappingMode mappingmode):Mapping("MAP_ZIGZAG","Zigzag",mappingmode){
    add_par_choice("DIRECTION","Direction","Normal|Inverse","Normal");
    add_par_choice("ALTERNATIVE","Alternative mode","No|Yes","Yes");
    add_par_choice("MODE","Mode","Normal|Arbitrary angle","Normal");
    add_par_real("ANGLE","Angle",0.0,90.0,30.0);
    update_parameters("");
};
MapZigzag::~MapZigzag(){
};

bool MapZigzag::update_parameters(string source_par){
    set_enabled_par("ANGLE",(get_par_choice("MODE")!="Normal"));
    if (source_par=="MODE") return true;
    return false;
};

void MapZigzag::do_map(int nx,int ny){
    alternative=(get_par_choice("ALTERNATIVE")=="Yes");
    arbitrarymode=(get_par_choice("MODE")!="Normal");
    inversedirection=(get_par_choice("DIRECTION")!="Normal");
    angle=get_par_real("ANGLE");

    if (arbitrarymode) do_map_arbitrary(nx,ny);
	else do_map_1x1(nx,ny);
};

void MapZigzag::do_map_1x1(int nx,int ny){
    bool inverse=inversedirection;

    for (int i=0;i<min(nx,ny)+1;i++){
	for (int j=0;j<i;j++){
	    if (inverse) do_map_once(j,i-j-1);
    		else do_map_once(i-j-1,j);
    	};
        if (alternative) inverse=!inverse;
    };
    
    if (nx>ny){
	for (int i=0;i<nx-ny;i++){
	    for (int j=0;j<ny;j++){
		if (inverse) do_map_once(i+j+1,ny-j-1);
		    else do_map_once(ny+i-j,j);
	    };
    	    if (alternative) inverse=!inverse;
	};
    };
    
    if (ny>nx){
	for (int i=0;i<ny-nx;i++){
	    for (int j=nx;j>0;j--){
		if (inverse) do_map_once(nx-j,i+j);
		    else do_map_once(j-1,nx+i-j+1);
	    };
    	    if (alternative) inverse=!inverse;
	};
    };
    
    for (int i=min(nx,ny)-1;i>0;i--){
	for (int j=0;j<i;j++){
	    if (inverse) do_map_once(nx+j-i,ny-j-1);
		else do_map_once(nx-j-1,ny+j-i);
	};
    	if (alternative) inverse=!inverse;
    };
};

void MapZigzag::do_map_arbitrary(int nx,int ny){
    REALTYPE epsilon=1e-3;
    if (angle<epsilon) angle=epsilon;
    if (angle>(90-epsilon)) angle=90-epsilon;
    REALTYPE factor=1.0/tan(angle*0.0174532925199433);
    
    bool jos;
    if (factor<1.0){
	factor=1.0/factor;
	jos=false;
    }else{
	jos=true;
    };

    bool inverse=inversedirection;

    int n1,n2;
    if (jos){
	n1=nx;
	n2=ny;
    }else{
	n1=ny;
	n2=nx;
    };
    
    for (int i=0;i<(int)(n1+n2/factor);i++){
	if (inverse){
	    for (int j=n2-1;j>=-1;j--){
		int i2=i-(int)(j/factor);
		if ((i2<0)||(i2>=n1)) continue;
		if (jos) do_map_once(i2,j);
		    else do_map_once(j,i2);
	    };
    /*	
    	    zona=range(n2-1,-1,-1)
//	for j in zona:
    	    i2=i-int(j/factor)
	    if i2<0 or i2>=n1:
		continue
	    if jos:
		a[i2][j]=k
	    else:
		a[j][i2]=k
	    k+=1
	if alternativ:
	    inverse=not inverse
	*/
	}else{//not inverse
	    for (int j=0;j<n2;j++){
		int i2=i-(int)(j/factor);
		if ((i2<0)||(i2>=n1)) continue;
		if (jos) do_map_once(i2,j);
		    else do_map_once(j,i2);
	    };

//    	    zona=range(0,n2);

	};
	if (alternative) inverse=!inverse;    
    };
};

