/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

// Maparea imagine sunet  - clasa de baza
#include <math.h>
#include "Mapping.h"
using namespace std;

Mapping::Mapping(string id, string name,MappingMode mappingmode):Process(id,name){
    //add inputs/outputs
    set_n_inputs(1);
    set_n_outputs(1);

    usenegative=false;
    img_size_proportion=1.0;
    snd=NULL;
    img=NULL;
    sndfreq=NULL;
    imgfreq=NULL;
    counter=0;
    this->mappingmode=mappingmode;
};

Mapping::~Mapping(){
    //nu trebuie sa sterg snd,img,sndfreq,imgfreq
    snd=NULL;
    img=NULL;
    sndfreq=NULL;
    imgfreq=NULL;
};

Object::Type Mapping::get_input_type(int n){
    if (n==0){
	switch(mappingmode){
	    case SND2IMG: return Object::SND;
	    case IMG2SND: return Object::IMG;
	    case SNDF2IMGF: return Object::SNDFREQ;
	    case IMGF2SNDF: return Object::IMGFREQ;
	};
    };
    return Object::NONE;
};

Object::Type Mapping::get_output_type(int n){
    if (n==0){
	switch(mappingmode){
	    case SND2IMG: return Object::IMG;
	    case IMG2SND: return Object::SND;
	    case SNDF2IMGF: return Object::IMGFREQ;
	    case IMGF2SNDF: return Object::SNDFREQ;
	};
    };
    return Object::NONE;
};

bool Mapping::do_process(){
    struct IO{
	Img *img;
	ImgFreq *imgfreq;
	Snd *snd;
	SndFreq *sndfreq;
	IO(){
	    img=NULL;imgfreq=NULL;
	    snd=NULL;sndfreq=NULL;
	};
    }input,output;

    int nx=0,ny=0;
    REALTYPE fnx=0.0,fny=0.0;
    switch(mappingmode){
	    case SND2IMG:
		input.snd=dynamic_cast<Snd *>(inputs[0]);
		output.img=dynamic_cast<Img *>(outputs[0]);
		fnx=fny=sqrt(input.snd->getnx());
		fnx*=img_size_proportion;
		fny/=img_size_proportion;
		nx=(int) fnx;nx=max(1,nx);
		ny=(int) fny;ny=max(1,ny);
		map(input.snd,output.img,nx,ny);
		break;
	    case SNDF2IMGF:
		input.sndfreq=dynamic_cast<SndFreq *>(inputs[0]);
		output.imgfreq=dynamic_cast<ImgFreq *>(outputs[0]);
		fnx=fny=sqrt(input.sndfreq->getnx());
    
		fnx*=img_size_proportion;
		fny/=img_size_proportion;
		nx=(int) fnx;nx=max(1,nx);
		ny=(int) fny;ny=max(1,ny);
		map(input.sndfreq,output.imgfreq,nx,ny);
		break;
	    case IMG2SND:
		input.img=dynamic_cast<Img *>(inputs[0]);
		output.snd=dynamic_cast<Snd *>(outputs[0]);
		nx=input.img->getnx();
		ny=input.img->getny();
		map(input.img,output.snd,nx,ny);
		break;
	    case IMGF2SNDF:
		input.imgfreq=dynamic_cast<ImgFreq *>(inputs[0]);
		output.sndfreq=dynamic_cast<SndFreq *>(outputs[0]);
		nx=input.imgfreq->getnx();
		ny=input.imgfreq->getny();
		map(input.imgfreq,output.sndfreq,nx,ny);
		break;
    };
    
    return true;
};


void Mapping::map(Snd *snd_,Img *img_,int nx,int ny){
    img_->copyinfofrom(snd_);
    snd=snd_;
    img=img_;
    imgfreq=NULL;
    sndfreq=NULL;

    fixsize(nx,ny);
    img->reset(nx,ny);
    
    counter=0;
    do_map(nx,ny);

    img=NULL;
    snd=NULL;
};

void Mapping::map(Img *img_,Snd *snd_,int nx,int ny){
    snd_->copyinfofrom(snd_);
    snd=snd_;
    img=img_;
    imgfreq=NULL;
    sndfreq=NULL;

    fixsize(nx,ny);
    snd->reset(nx*ny);
    
    counter=0;
    do_map(nx,ny);

    img=NULL;
    snd=NULL;
};

void Mapping::map(ImgFreq *imgfreq_,SndFreq *sndfreq_,int nx,int ny){
    sndfreq_->copyinfofrom(imgfreq_);
    sndfreq=sndfreq_;
    imgfreq=imgfreq_;
    img=NULL;
    snd=NULL;

    fixsize(nx,ny);
    sndfreq->reset(nx*ny);
    
    counter=0;
    do_map(nx/2,ny/2);

    imgfreq=NULL;
    sndfreq=NULL;
};


void Mapping::map(SndFreq *sndfreq_,ImgFreq *imgfreq_,int nx,int ny){
    imgfreq_->copyinfofrom(sndfreq_);
    sndfreq=sndfreq_;
    imgfreq=imgfreq_;
    img=NULL;
    snd=NULL;

    fixsize(nx,ny);
    imgfreq->reset(nx,ny);
    
    counter=0;
    do_map(nx/2,ny/2);

    imgfreq=NULL;
    sndfreq=NULL;
};


void Mapping::do_map_once(int ix,int iy){
    REALTYPE s,c;
    int K=counter++;
    switch(mappingmode){
	case SND2IMG:		
		img->set(ix,iy,snd->get(K));
	    break;
	case IMG2SND:
		snd->set(K,img->get(ix,iy));
	    break;
	case SNDF2IMGF:
		sndfreq->get(K*2,c,s);
		imgfreq->set(ix,iy,c,s);
		if (ix){
		    sndfreq->get(K*2+1,c,s);
		    imgfreq->set(-ix,iy,c,s);
		};
	    break;
	case IMGF2SNDF:
		imgfreq->get(ix,iy,c,s);
		sndfreq->set(K*2,c,s);
		if (ix){
		    imgfreq->get(-ix,iy,c,s);
		    sndfreq->set(K*2+1,c,s);
		};
	    break;
	case FILLARRAY:
	    //sa scriu array[ix,iy]=sx
	    break;
	default:
	    break;
    };
};




