/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

// Maparea img[freq]<--->snd[freq]  - clasa de baza
#ifndef MAPPING_H
#define MAPPING_H

#include <string>
#include "../../Objects/Img.h"
#include "../../Objects/Snd.h"
#include "../../Objects/ImgFreq.h"
#include "../../Objects/SndFreq.h"
#include "../../Process/Process.h"


class Mapping:public Process{
    public:
	enum MappingMode{SND2IMG,IMG2SND,SNDF2IMGF,IMGF2SNDF,FILLARRAY};
	Mapping(std::string id, std::string name, MappingMode mappingmode);
	~Mapping();

	Object::Type get_input_type(int n);
	Object::Type get_output_type(int n);

    protected:    
	bool usenegative;//daca folosesc freq negative (2nx*ny), altfel folosesc de marime nx*ny
	void do_map_once(int ix,int iy);
	MappingMode mappingmode;
	
	REALTYPE img_size_proportion;//the proportion of the sizes of the destination Ima/ImgFreq (if the source is sound)
	
    private:
	bool do_process();
	void map(Snd *snd_,Img *img_,int nx,int ny);
	void map(Img *img_,Snd *snd_,int nx,int ny);
	void map(ImgFreq *imgfreq_,SndFreq *sndfreq_,int nx,int ny);
	void map(SndFreq *sndfreq_,ImgFreq *imgfreq_,int nx,int ny);

	//functia de mapping
	virtual void do_map(int nx,int ny)=0;
	
	//folosit ca sa reglez nx-ul si ny daca sunt puse anumite restricti de mapping (ex. hilbert)
	virtual void fixsize(int &nx,int &ny)=0;
	
/*	enum {
	    nullmode,
	    snd2img,img2snd,
	    sndf2imgf,imgf2sndf,
	    fillarray//modul asta este pentru a pune datele pt python gui
	}mode;
*/
	Snd *snd;
	Img *img;
	SndFreq *sndfreq;
	ImgFreq *imgfreq;
	
	int counter;
    
};

#endif
