/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "Process.h"
using namespace std;

Process::Process(string id,string name):Parameters(id,name){
};

Process::~Process(){
};

string Process::get_id(){
    return get_par_id();
};

int Process::get_n_inputs(){
    return inputs.size();
};

int Process::get_n_outputs(){
    return outputs.size();
};

bool Process::set_input(int n,Object *obj){
    if ((n<0)&&(n>get_n_inputs())) return false;
    if (get_input_type(n)!=obj->get_type()) return false;
    inputs[n]=obj;
    return true;
};

bool Process::set_output(int n,Object *obj){
    if ((n<0)&&(n>get_n_outputs())) return false;
    if (get_output_type(n)!=obj->get_type()) return false;
    outputs[n]=obj;
    return true;
};

bool Process::process(){
    if (!all_ins_outs_set()) {
	return false;
    };
    return do_process();
};


void Process::set_n_inputs(int n){
    inputs.resize(n);
    for (int i=0;i<n;i++) inputs[i]=NULL;
};

void Process::set_n_outputs(int n){
    outputs.resize(n);
    for (int i=0;i<n;i++) outputs[i]=NULL;
};


bool Process::all_ins_outs_set(){
    int ni=get_n_inputs();
    int no=get_n_outputs();
    for (int i=0;i<ni;i++) if (inputs[i]==NULL) return false;
    for (int i=0;i<no;i++) if (outputs[i]==NULL) return false;
    
    return true;
};
