/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef PROCESS_H
#define PROCESS_H

#include <string>
#include <vector>
#include "../Objects/Object.h"
#include "../Parameters/Parameters.h"


class Process:public Parameters{
    public:
	Process(std::string id,std::string name);
	~Process();
	std::string get_id();
	std::string get_name();
	
	//informatii despre inputs/outputs
	int get_n_inputs();
	int get_n_outputs();
	virtual Object::Type get_input_type(int n)=0;
	virtual Object::Type get_output_type(int n)=0;
		
	//setare inputs/outputs (returnz true daca obiectul s-a putut adauga)
	bool set_input(int n,Object *obj);
	bool set_output(int n,Object *obj);
	
	//procesare
	bool process();//procesez (returnez false daca nu s-a putut procesa)
	
    protected:
	virtual bool do_process()=0;//returneaza false daca nu se poate procesa
	
	void set_n_inputs(int n);
	void set_n_outputs(int n);
	
	std::vector <Object *> inputs,outputs;
	    
    private:
	bool all_ins_outs_set();//returneaza false daca un input sau output este NULL 
};


#endif

