/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <fftw3.h>
#include <math.h>
#include <stdio.h>

#define fftwf_real float

#include "Fourier.h"

fftw_r2r_kind getfftwkind(FourierRType type,int subtype){
    switch(type){
	case (F_DCT):
		switch (subtype){
		    case 0: return FFTW_REDFT00;
		    case 1: return FFTW_REDFT01;
		    case 2: return FFTW_REDFT10;
		    case 3: return FFTW_REDFT11;
		};
	break;
	case (F_DST):
		switch (subtype){
		    case 0: return FFTW_RODFT00;
		    case 1: return FFTW_RODFT01;
		    case 2: return FFTW_RODFT10;
		    case 3: return FFTW_RODFT11;
		};
	break;
    };
};


Fourier::Fourier(){
};

Fourier::~Fourier(){
};

void Fourier::fft(Snd &snd,SndFreq &sndfreq,bool clearsource){
    int sndsize=snd.getnx();
    sndfreq.reset(0);
    sndfreq.copyinfofrom(&snd);
    if (sndsize==0) return;

    fftwf_real *data=new fftwf_real[sndsize];
    fftwf_plan planfftw;

    for (int i=0;i<sndsize;i++) data[i]=snd.get(i);
    if (clearsource) snd.reset(0);

    planfftw=fftwf_plan_r2r_1d(sndsize,data,data,FFTW_R2HC,FFTW_ESTIMATE);
    
    fftwf_execute(planfftw);
    fftwf_destroy_plan(planfftw);
    
    sndfreq.reset(sndsize);//aloc memorie pt sndfreq

    REALTYPE norm=1.0/sndsize*2.0;
    sndfreq.set(0,data[0]*norm,0);
    for (int i=1;i<(sndsize/2);i++){
	sndfreq.set(i,data[i]*norm,-data[sndsize-i]*norm);
    };

    if (sndsize%2==0) sndfreq.set(sndsize/2,data[sndsize/2]*norm,0);
	else sndfreq.set(sndsize/2,data[sndsize/2]*norm,-data[sndsize/2+1]*norm);

    delete [] data; data=NULL;
};



void Fourier::ifft(SndFreq &sndfreq,Snd &snd,bool clearsource){
    int sndsize=sndfreq.getnx();
    snd.reset(0);
    snd.copyinfofrom(&sndfreq);

    if (sndsize==0) return;
    fftwf_real *data=new fftwf_real[sndsize];
    fftwf_plan planfftw;

    for (int i=1;i<(sndsize+1)/2;i++) {
	REALTYPE c,s;
	sndfreq.get(i,c,s);
	data[i]=c*0.5;
	data[sndsize-i]=-s*0.5;
    };
    {
	REALTYPE c,s;
	sndfreq.get(0,c,s);
	data[0]=c*0.5;
	sndfreq.get(sndsize/2,c,s);
	data[(sndsize+1)/2]=c*0.5;
	if (sndsize%2!=0) data[(sndsize+1)/2]=-s*0.5;
    };


    if (clearsource) sndfreq.reset(0);

    planfftw=fftwf_plan_r2r_1d(sndsize,data,data,FFTW_HC2R,FFTW_ESTIMATE);
    
    fftwf_execute(planfftw);

    fftwf_destroy_plan(planfftw);
        
    snd.reset(sndsize);//aloc memorie pt sndfreq
    for (int i=0;i<sndsize;i++){
	snd.set(i,data[i]);
    };
    delete [] data; data=NULL;
};

void Fourier::rr(Snd &snd1,Snd &snd2,bool clearsource,FourierRType typeX,int subtypeX){
    int sizex=snd1.getnx();
    snd2.copyinfofrom(&snd1);

    if ((&snd1)!=(&snd2)) snd2.reset(0);
    if (sizex==0) return;
    
    fftwf_real *data=new fftwf_real[sizex];
    for(int i=0;i<sizex;i++) data[i]=0;
    fftwf_plan planfftw;
    
    for (int i=0;i<sizex;i++) {
        data[i]=snd1.get(i);
    };

    if (clearsource) snd1.reset(0);

    planfftw=fftwf_plan_r2r_1d(sizex,data,data,
    getfftwkind(typeX,subtypeX),FFTW_ESTIMATE);

    fftwf_execute(planfftw);
    fftwf_destroy_plan(planfftw);
    snd2.reset(sizex);
    
    float norm=2.0/((float)sizex);
    for (int i=0;i<sizex;i++) snd2.set(i,data[i]*norm);
	    
    delete [] data;
};




///////////////////////////////////////
///////////////////////////////////////
///////////////////////////////////////
///////////////////////////////////////
///////////////////////////////////////
///////////////////////////////////////
///////////////////////////////////////
///////////////////////////////////////


void Fourier::fft(Img &img,ImgFreq &imgfreq,bool clearsource){
    int sizex=img.getnx();
    int sizey=img.getny();
    imgfreq.copyinfofrom(&img);
    
    imgfreq.reset(0,0);
    if ((sizex==0)||(sizey==0)) return;
    
    int stride=2*(sizey/2+1);
    fftwf_real *data=new fftwf_real[sizex*stride];
    fftwf_plan planfftw;

    for (int i=0;i<sizex;i++) 
	for (int j=0;j<sizey;j++)
	    data[i*stride+j]=img.get(i,j);
    if (clearsource) img.reset(0,0);

    planfftw=fftwf_plan_dft_r2c_2d(sizex,sizey,data,(fftwf_complex*)data,FFTW_ESTIMATE);

    fftwf_execute(planfftw);

    fftwf_destroy_plan(planfftw);

    imgfreq.reset(sizex,sizey);

    int sx12=sizex/2;
    REALTYPE gain=1.0/((REALTYPE)sizex*(REALTYPE)sizey)*2.0;
    for (int j=0;j<sizey/2+1;j++){
	for (int i=0;i<sx12;i++) {
	    imgfreq.set(i,j,data[(j*2+i*stride)]*gain,-data[(j*2+i*stride)+1]*gain);
	};
	for (int i=0;i<sx12;i++) {
	    imgfreq.set(i-sx12,j,data[j*2+(i+sx12)*stride]*gain,-data[j*2+(i+sx12)*stride+1]*gain);
	};
    };

    delete [] data;
};

void Fourier::ifft(ImgFreq &imgfreq,Img &img,bool clearsource){
    int sizex=imgfreq.getnx();
    int sizey=imgfreq.getny();
    img.copyinfofrom(&imgfreq);
    
    img.reset(0,0);
    if ((sizex==0)||(sizey==0)) return;
    
    int stride=2*(sizey/2+1);
    fftwf_real *data=new fftwf_real[sizex*stride];
    for(int i=0;i<sizex*stride;i++) data[i]=0;
    fftwf_plan planfftw;
    
    int sx12=sizex/2;
    for (int j=0;j<sizey/2+1;j++){
	for (int i=0;i<sx12;i++) {
	    REALTYPE s,c;
	    imgfreq.get(i,j,c,s);
	    data[(j*2+i*stride)]=c;
	    data[(j*2+i*stride)+1]=-s;
	};
	for (int i=0;i<sx12;i++) {
	    REALTYPE s,c;
	    imgfreq.get(i-sx12,j,c,s);
	    data[j*2+(i+sx12)*stride]=c;
	    data[j*2+(i+sx12)*stride+1]=-s;
	};
    };
    
    if (clearsource) imgfreq.reset(0,0);

    planfftw=fftwf_plan_dft_c2r_2d(sizex,sizey,(fftwf_complex*)data,data,FFTW_ESTIMATE);


    fftwf_execute(planfftw);

    fftwf_destroy_plan(planfftw);

    img.reset(sizex,sizey);
    
    for (int i=0;i<sizex;i++) 
	for (int j=0;j<sizey;j++){
	    img.set(i,j,data[i*stride+j]*0.5);
	};
	    
    delete [] data;
};


void Fourier::rr(Img &img1,Img &img2,bool clearsource,FourierRType typeX,int subtypeX,FourierRType typeY,int subtypeY){
    int sizex=img1.getnx();
    int sizey=img1.getny();
    img2.copyinfofrom(&img1);
    
    if ((&img1)!=(&img2)) img2.reset(0,0);
    if ((sizex==0)||(sizey==0)) return;
    
//    int stride=2*(sizey/2+1);
    fftwf_real *data=new fftwf_real[sizex*sizey];
    for(int i=0;i<sizex*sizey;i++) data[i]=0;
    fftwf_plan planfftw;
    
    for (int j=0;j<sizey;j++){
	for (int i=0;i<sizex;i++) {
	    data[i*sizey+j]=img1.get(i,j);
	};
    };

    if (clearsource) img1.reset(0,0);

    planfftw=fftwf_plan_r2r_2d(sizex,sizey,data,data,
	getfftwkind(typeX,subtypeX),getfftwkind(typeY,subtypeY),FFTW_ESTIMATE);

    fftwf_execute(planfftw);
    fftwf_destroy_plan(planfftw);
    img2.reset(sizex,sizey);
    
    float norm=4.0/((float)sizex*(float)sizey);
    for (int i=0;i<sizex;i++) 
	for (int j=0;j<sizey;j++)
	    img2.set(i,j,data[i*sizey+j]*norm);
	    
    delete [] data;
};


/*
void Fourier::idht2d(ImgFreq &imgfreq,Img &img,bool clearsource){
    int sizex=imgfreq.getnx();
    int sizey=imgfreq.getny();
    
    img.reset(0,0);
    if ((sizex==0)||(sizey==0)) return;
    
    fftwf_real *data=new fftwf_real[sizex*sizey];
    for(int i=0;i<sizex*sizey;i++) data[i]=0;
    fftwf_plan planfftw;
    
    int sx12=sizex/2;//?????
    int datasize=sizex*sizey;
    for (int j=1;j<sizey/2+1;j++){
	for (int i=1;i<sx12;i++) {
	    REALTYPE s,c;
	    imgfreq.get(i,j,c,s);

	    ///sa pun mai intai de la i,j=1, apoi ce ramane sa pun doar la frecv pozitive
	    //sa nu uit sa pun sinusul la minus


	    data[j*sizex+i]=c;//ok stanga sus cosinus
	    data[datasize-j*sizex+sizex-i]=s;//ok dreapta jos sinus

//	    imgfreq.get(-i,j,c,s);

//	    data[j*sizex+sizex-(i+1)]=c;//ok dreapta sus cosinus
//	    data[datasize-(j+1)*sizex+i]=c;//ok stanga jos sinus

//	    data[j*sizex+i]=c;//ok stanga sus cosinus
//	    data[j*sizex+sizex-(i+1)]=c;//ok dreapta sus cosinus
//	    data[datasize-(j+1)*sizex+i]=c;//ok stanga jos sinus
//	    data[datasize-(j+1)*sizex+sizex-(i+1)]=c;//ok dreapta jos sinus
	};

//	data[datasize-1-sizex+1]=1;


    };

    
    if (clearsource) imgfreq.reset(0,0);

//FFTW_REDFT00
    planfftw=fftwf_plan_r2r_2d(sizex,sizey,data,data,FFTW_DHT,FFTW_DHT,FFTW_ESTIMATE);

    fftwf_execute(planfftw);
    fftwf_destroy_plan(planfftw);

    img.reset(sizex,sizey);
    
    for (int i=0;i<sizex;i++) 
	for (int j=0;j<sizey;j++)
	    img.set(i,j,data[i*sizex+j]*0.5);
	    
    delete [] data;
};
*/


