/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

//Transformari fourier
#ifndef FOURIER_H
#define FOURIER_H

#include "../../Objects/Object.h"
#include "../../Objects/Snd.h"
#include "../../Objects/SndFreq.h"
#include "../../Objects/Img.h"
#include "../../Objects/ImgFreq.h"

enum FourierRType{
    F_DCT,F_DST
};

class Fourier{
    public:
	Fourier();
	~Fourier();

	// clearsource elibereaza memoria dupa ce am transferat din snd
	void fft(Snd &snd,SndFreq &sndfreq,bool clearsource=0);
	void ifft(SndFreq &sndfreq,Snd &snd,bool clearsource=0);

	void fft(Img &img,ImgFreq &imgfreq,bool clearsource=0);
	void ifft(ImgFreq &imgfreq,Img &img,bool clearsource=0);


	void rr(Snd &snd1,Snd &snd2,bool clearsource,FourierRType typeX,int subtypeX);
	void rr(Img &img1,Img &img2,bool clearsource,FourierRType typeX,int subtypeX,FourierRType typeY,int subtypeY);

    private:
};


#endif


