/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "ParDialog.h"

#include <wx/stattext.h>
#include <wx/tokenzr.h>
#include <string>
using namespace std;
DEFINE_EVENT_TYPE(ID_PAR_DIALOG_UPDATE_PARAMETER)

BEGIN_EVENT_TABLE( ParDialog, wxPanel )
    EVT_SLIDER( ID_SLIDER, ParDialog::OnSlider)
    EVT_TEXT_ENTER( ID_TEXTCTRL, ParDialog::OnTextCtrl)
    EVT_CHOICE( ID_CHOICE, ParDialog::OnChoice)
    EVT_COMBOBOX( ID_COMBOBOX, ParDialog::OnComboBox)
    EVT_CHECKBOX( ID_CHECKBOX, ParDialog::OnCheckBox)
END_EVENT_TABLE()


ParDialog::ParDialog(wxWindow *parent_,Par *par_):wxPanel(parent_,-1){
    par=par_;
    parent=parent_;
    control.slider=NULL;
    control.textctrl=NULL;
    control.choice=NULL;
    control.combobox=NULL;
    control.checkbox=NULL;

    lock_update=false;    
    add_parameter();
};

ParDialog::~ParDialog(){
};

void ParDialog::add_parameter(){
    wxSizer *sizer=new wxBoxSizer(wxVERTICAL);
    SetSizer(sizer);
    switch (par->get_type()){
	case INT:
	case REAL:
	    {
	    wxBoxSizer *sv=new wxBoxSizer(wxVERTICAL);
	    sizer->Add(sv,5,wxEXPAND|wxFIXED_MINSIZE);

	    wxBoxSizer *sh=new wxBoxSizer(wxHORIZONTAL);
	    sv->Add(sh,0,wxEXPAND|wxFIXED_MINSIZE);
	    sh->Add(new wxStaticText(this,-1,wxString(par->get_name().c_str(),wxConvUTF8)),2,wxGROW);

	    control.textctrl=new wxTextCtrl(this,ID_TEXTCTRL,wxT(""),wxDefaultPosition,wxSize(60,-1),wxTE_RIGHT|wxTE_PROCESS_ENTER);
	    sh->Add(control.textctrl,0);
	    sh->AddStretchSpacer(1);
    
	    sv->Add(control.slider=new wxSlider (this,ID_SLIDER,0,0,1000,wxDefaultPosition,wxSize(-1,20)),1,wxGROW|wxFIXED_MINSIZE);
	    }
	    break;
	case CHOICE:
	    {
	    wxString schoices=wxString(par->choice_pars.choices.c_str(),wxConvUTF8);
	    wxStringTokenizer tkz(schoices,wxT("|"));
	    wxArrayString ar;
	    int nchoice=0,k=0;
	    wxString choice=wxString(par->choice_pars.val.c_str(),wxConvUTF8);
	    while ( tkz.HasMoreTokens()){
		wxString current=tkz.GetNextToken();
		ar.Add(current);
		if (current==choice) nchoice=k;
		k++;
	    };
	    sizer->Add(new wxStaticText(this,-1,wxString(par->get_name().c_str(),wxConvUTF8)),1,wxGROW|wxALIGN_CENTER_VERTICAL);
	    sizer->Add(control.choice=new wxChoice (this,ID_CHOICE,wxDefaultPosition,wxDefaultSize,ar),0,wxGROW);
	    control.choice->SetSelection(nchoice);
	    };
	    break;	
	case INTCOMBO:
	case REALCOMBO:	
	    {
	    wxString schoices=wxString(par->intcombo_pars.choices.c_str(),wxConvUTF8);
	    wxStringTokenizer tkz(schoices,wxT("|"));
	    wxArrayString ar;
	    while ( tkz.HasMoreTokens()){
		ar.Add(tkz.GetNextToken());
	    };
	    wxString sval;
	    if (par->get_type()==INTCOMBO) sval.Printf(wxT("%d"),par->int_pars.val);
	    if (par->get_type()==REALCOMBO) sval.Printf(wxT("%g"),par->real_pars.val);
		
	    sizer->Add(new wxStaticText(this,-1,wxString(par->get_name().c_str(),wxConvUTF8)),1,wxGROW|wxALIGN_CENTER_VERTICAL);
	    sizer->Add(control.combobox=new wxComboBox (this,ID_COMBOBOX,sval,wxDefaultPosition,wxDefaultSize,ar),0,wxFIXED_MINSIZE);
	    };
	    break;	

	case SEPARATOR:
	    sizer->Add(new wxStaticText(this,-1,wxString(par->get_name().c_str(),wxConvUTF8)),1,wxGROW|wxALIGN_CENTER_VERTICAL);
	    break;
	case BOOL:
	    sizer->Add(control.checkbox=new wxCheckBox (this,ID_CHECKBOX,wxString(par->get_name().c_str(),wxConvUTF8),wxDefaultPosition,wxDefaultSize),0,wxFIXED_MINSIZE);
	    control.checkbox->SetValue(par->get_bool_value());
	    
	    break;
    };
    sizer->AddStretchSpacer(1);

    Update_Widgets(ID_NULL);
};

void ParDialog::Update(){
    Show(par->enabled);

    Update_Widgets(ID_OTHER_PARDIALOG);
};


void ParDialog::Update_Widgets(Id not_this){
    if ((control.textctrl)&&(not_this!=ID_TEXTCTRL)){
	wxString sval;
        if (par->type==INT) sval.Printf(wxT("%d"),par->int_pars.val);
	    else sval.Printf(wxT("%.4f"),par->real_pars.val);
	lock_update=true;
	control.textctrl->SetValue(sval);
	lock_update=false;
    };
    if ((control.slider)&&(not_this!=ID_SLIDER)){
	REALTYPE min=control.slider->GetMin();
        REALTYPE max=control.slider->GetMax();    
	REALTYPE x=(par->get_value_for_slider())*(max-min)+min;
	control.slider->SetValue((int)x);
    };

    if (not_this!=ID_OTHER_PARDIALOG){
	wxCommandEvent event=wxCommandEvent(ID_PAR_DIALOG_UPDATE_PARAMETER,1);
	event.SetClientData(par);
        parent->AddPendingEvent(event);
    };

};


void ParDialog::OnSlider(wxCommandEvent& event){
    if (!control.slider) return;
    REALTYPE min=control.slider->GetMin();
    REALTYPE max=control.slider->GetMax();
    par->set_value_from_slider((control.slider->GetValue()-min)/(max-min));
    
    Update_Widgets(ID_SLIDER);
};

void ParDialog::OnTextCtrl(wxCommandEvent& event){
    if (!control.textctrl) return;
    if (lock_update) return;
    wxString sval=control.textctrl->GetValue();
    if (par->type==INT){
	long int val=0;
	if (sval.ToLong(&val)) par->set_int_value(val);
    };
    if (par->type==REAL){
	double val=0.0;
	if (sval.ToDouble(&val)) par->set_real_value(val);
    };
    Update_Widgets(ID_TEXTCTRL);
};

void ParDialog::OnChoice(wxCommandEvent& event){
    if (!control.choice) return;
    wxString wstr=control.choice->GetStringSelection();
    string str=(const char*)(wstr.mb_str(wxConvUTF8));
    par->set_choice_value(str);
    Update_Widgets(ID_CHOICE);
};

void ParDialog::OnComboBox(wxCommandEvent& event){
    if (!control.combobox) return;
    wxString sval=control.combobox->GetValue();
    
    if (par->get_type()==INTCOMBO){
	long int val=0;
	if (!sval.ToLong(&val)) return;
	par->set_int_value(val);
    };
    if (par->get_type()==REALCOMBO){
	double val=0;
	if (!sval.ToDouble(&val)) return;
	par->set_real_value(val);
    };
    
    Update_Widgets(ID_COMBOBOX);
};

void ParDialog::OnCheckBox(wxCommandEvent& event){
    if (!control.checkbox) return;
    par->set_bool_value(control.checkbox->IsChecked());
    Update_Widgets(ID_CHECKBOX);
};


