/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef PAR_DIALOG_H
#define PAR_DIALOG_H

#include "../Parameters/Par.h"
#include <wx/sizer.h>
#include <wx/panel.h>
#include <wx/slider.h>
#include <wx/textctrl.h>
#include <wx/choice.h>
#include <wx/combobox.h>
#include <wx/checkbox.h>

DECLARE_EVENT_TYPE(ID_PAR_DIALOG_UPDATE_PARAMETER,-1)

class ParDialog:public wxPanel{
    DECLARE_EVENT_TABLE()
    public:
	ParDialog(wxWindow *parent_,Par *par_);
	~ParDialog();
	void Update();
	
	enum Id {ID_NULL,ID_OTHER_PARDIALOG,ID_SLIDER,ID_TEXTCTRL,ID_CHOICE,ID_COMBOBOX,ID_CHECKBOX} id;
    private:
	Par *par;
	wxWindow *parent;
	void add_parameter();
	void OnSlider(wxCommandEvent& event);
	void OnTextCtrl(wxCommandEvent& event);
	void OnChoice(wxCommandEvent& event);
	void OnComboBox(wxCommandEvent& event);
	void OnCheckBox(wxCommandEvent& event);
	
	void Update_Widgets(Id not_this);
	
	//controlleri
	struct{
	    wxSlider *slider;
	    wxTextCtrl *textctrl;
	    wxChoice *choice;
	    wxComboBox *combobox;
	    wxCheckBox *checkbox;
	} control;
	
	bool lock_update;//pentru ca sa nu permit update-ul recursiv
};


#endif

