/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include "ParametersDialog.h"
#include <wx/statbox.h>
#include <wx/sizer.h>
using namespace std;

#include <wx/listimpl.cpp>
WX_DEFINE_LIST(ParDialogList);


BEGIN_EVENT_TABLE( ParametersDialog, wxDialog )
    EVT_COMMAND( 1, ID_PAR_DIALOG_UPDATE_PARAMETER, ParametersDialog::OnUpdateParameter)//test
END_EVENT_TABLE()

ParametersDialog::ParametersDialog(Parameters *pars_):wxDialog(NULL,-1,wxT("Parameters"),wxDefaultPosition,wxDefaultSize,wxRESIZE_BORDER){
    pars=pars_;
    
    yparameters=0;
    SetTitle(wxString(pars->get_par_name().c_str(),wxConvUTF8));
    wxBoxSizer *topsizer = new wxBoxSizer(wxVERTICAL);
    add_all_parameters(topsizer);
    
    topsizer->Add(new wxButton(this,wxID_OK,wxT("Close")),0,wxALIGN_CENTER_HORIZONTAL);
    SetSizer(topsizer);
    topsizer->SetSizeHints(this);
    UpdateParameters("",true);
};

void ParametersDialog::add_all_parameters(wxSizer *topsizer){
    wxBoxSizer* allsizer = new wxBoxSizer(wxHORIZONTAL);
    topsizer->Add(allsizer,1,wxEXPAND);
    
    list <Par>::iterator iter; 
    int maxyp=0;
    wxStaticBoxSizer *sizer=NULL;
    for (iter=pars->pars.begin();iter!=pars->pars.end();iter++){
	Par *par=&(*iter);
	if ((par->get_type()==SEPARATOR)||(sizer==NULL)){
	    const char *title="";
	    if (par->get_type()==SEPARATOR) title=par->get_name().c_str();
	    sizer=new wxStaticBoxSizer(wxVERTICAL,this,wxString(title,wxConvUTF8));
	    allsizer->Add(sizer,1,wxEXPAND);

	    sizer->AddSpacer(10);
	    if (maxyp>yparameters) yparameters=maxyp;
	    maxyp=0;
	};

	if (par->get_type()!=SEPARATOR) add_parameter(sizer,par);
	maxyp++;
    };
    if (maxyp>yparameters) yparameters=maxyp;    
};

void ParametersDialog::add_parameter(wxSizer *sizer,Par *par){
    ParDialog *dialog = new ParDialog(this,par);
    sizer->Add(dialog,1,wxEXPAND);
    pardialoglist.Append(dialog);
};

void ParametersDialog::OnUpdateParameter(wxCommandEvent& event){
    Par *par=(Par *)event.GetClientData();
    string id;
    if (par) id=par->get_id();
    UpdateParameters(id);
};

void ParametersDialog::UpdateParameters(string source_par,bool force){
    if (pars->update_parameters(source_par)||(force)){
	for ( ParDialogList::Node *node = pardialoglist.GetFirst(); node!=NULL;node=node->GetNext()){
    	    ParDialog *current=node->GetData();
	    current->Update();
	}	
	
	wxSizer *topsizer=GetSizer();
	if (topsizer){
	    int sizex,sizey;
	    GetSize(&sizex,&sizey);
	    topsizer->SetSizeHints(this);
	    SetSize(sizex,-1);
	};
	Layout();
    };    
};


