/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#ifndef GLOBALS_H
#define GLOBALS_H

#define REALTYPE float
#define PI 3.14159265358979

int clamp(int val,int min,int max);
REALTYPE clamp(REALTYPE val,REALTYPE min,REALTYPE max);
int min(int x,int y);
int max(int x,int y);
void swap(int &x,int &y);
void swap(REALTYPE &x,REALTYPE &y);

#define LOG_10 2.302585093
#define dB2rap(dB) ((exp((dB)*LOG_10/20.0)))
#define rap2dB(rap) ((20*log(rap)/LOG_10))

#endif

