/*
  H Y P E R M A M M U T
 
  Copyright (C) 2006 Nasca Octavian Paul
  Author: Nasca Octavian Paul

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License 
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License (version 2) for more details.

  You should have received a copy of the GNU General Public License (version 2)
  along with this program; if not, write to the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "Objects/Object.h"
#include "Objects/Snd.h"
#include "Objects/SndFreq.h"
#include "Objects/Img.h"
#include "Objects/ImgFreq.h"
#include "Parameters/Parameters.h"
#include "Process/Transform/Fourier.h"
#include "Process/Mapping/MapFractal.h"
#include "Process/Mapping/MapScanning.h"
#include "Process/Mapping/MapZigzag.h"
#include "Process/Generator/SndFreq/PADsynthGen.h"
#include "Process/Generator/Snd/ExpdecayGen.h"
#include "Process/Generator/Random.h"
#include "Process/Effect/SndFreq/FilterS.h"
#include "Process/Effect/SndFreq/TranslateS.h"
#include "Process/Effect/SndFreq/PhaseChangeS.h"
#include "Process/Effect/SndFreq/AmplitudePhaseS.h"
#include "Process/Effect/ImgFreq/FilterI.h"
#include "Process/Effect/ImgFreq/AmplitudePhaseI.h"
#include "Process/Effect/ImgFreq/PhaseChangeI.h"
#include "Process/Effect/ImgFreq/StretchIF.h"
#include "Process/Effect/Img/StretchI.h"
#include <wx/filedlg.h>
#include "IO/AInput.h"

#include "IO/ImgInput.h"
//int main(){
/*
    Img img(10,10);
    
    for (int i=0;i<100;i++){
	img.set(i/10,i%10,i);
    };
    img.savefile("img.out");
    
    Img img2("img.out");
    printf("%d %d\n",img2.getnx(),img2.getny());
    for (int i=0;i<100;i++){
	printf("%.3g ",img2.get(i/10,i%10));
    };
    printf("\n");
*/
/*
    Snd snd(10000);
    for (int i=0;i<10000;i++) snd.set(i,i/10);
    snd.savefile("snd.out");
    
    Snd snd2("snd.out");
    for (int i=0;i<10000;i++) printf("%.3g ",snd.get(i));
*/    

/*    ImgFreq ii(1000,1000);
    int k=0;
    for (int j=-10;j<10;j++){
	for (int i=-10;i<10;i++){
	    ii.set(i,j,1,0);
	    REALTYPE s,c;
	    ii.get(i,j,c,s);
	    if ((int)c){
		k++;
	    };
	    
	};
    };
   printf("2k=%d\n",k*2);
    ii.savefile("imgf.out");
*/
/*
    SndFreq ss(100);
    for (int i=0;i<1000;i++){
	ss.set(i,10.0,0.0);
	REALTYPE s,c;
	ss.get(i,s,c);
	if ((int)s) printf("%d ",i); 
    };
    ss.savefile("sndf.out");
*/


/*test FFT sunet
    int n=11;
    Snd snd(n);
    for (int i=0;i<n;i++) snd.set(i,(i==3?1:0/n)*0+rand()%123+0*cos(0.0*i*2.0*3.1415926535/n));
//    for (int i=0;i<n;i++) snd.set(i,sin(2.0/n*3.14159*i));
    SndFreq sf;
    
    Fourier f;
    snd.debug();
    f.fft(snd,sf,false);
    sf.debug();
    f.ifft(sf,snd,false);
    snd.debug();
    f.fft(snd,sf,false);
    sf.debug();
    
*/
/*

    //test fft imagine
    Img img(3,3);
    ImgFreq imgf;
    
    for (int i=0;i<img.getnx();i++){
	for (int j=0;j<img.getny();j++){
	    img.set(i,j,(((i==0)&&(j==0))?1:0)*0+rand()%123+0*cos(1*j*3.1415926/img.getny()*2.0+1*i*3.1415926/img.getnx()*2.0));
	};
    };
    img.debug();

    f.fft(img,imgf,false);   

    imgf.debug();
    
    f.ifft(imgf,img,false);
    img.debug();

    return 0;
*/
/*    Snd snd;
    snd.import_audio("misc/a.wav",0);
    snd.export_audio("b.wav");
    snd.debug();
*/

/*
    Img img1,img2;
    img1.import_image("a.jpg",0,0);

    Fourier f;
    ImgFreq imgf;
    printf("FFT\n");
    f.fft(img1,imgf,true);
    
    printf("PROCESS\n");
 
   for (int j=0;j<imgf.getny()/2+1;j++){
	for (int i=-imgf.getnx()/2;i<imgf.getnx()/2;i++){
	    if (sqrt((j*j+i*i))<30.0) imgf.set(i,j,0,0);
	    if (sqrt((j*j+i*i))>100.0) imgf.set(i,j,0,0);
	};
    };

    printf("IFFT\n");
    f.ifft(imgf,img2,true);
    img2.export_image("b.ppm");

*/


/*    Snd snd;
    SndFreq sf(512);
    Fourier f;
    f.irr(sf,snd,false);
    snd.debug2image("snd.ppm");
*/
/* //diferite transformari r2r la imagine
    Img img;
    Fourier f;
    for (int kk=0;kk<2;kk++){
	for (int k=0;k<4;k++){
//	    for (int j=0;j<3;j++){
//		for (int i=0;i<3;i++){
//		    img.reset(128,128);
		    char tmp[100];
		    snprintf(tmp,100,"%s%d.ppm",
			(kk==0)?"C":"S",k);
		    printf("%s\n",tmp);
//		    img.import_image("a.jpg");
		    img.reset(256,256);
		    srand(1);
		    for (int i=0;i<400;i++) {
			img.set(i%20,i/20,rand()%10-5);
		    };
		    f.rr(img,img,false,(kk==0)?F_DCT:F_DST,k,(kk==0)?F_DCT:F_DST,k);
//		    img.set(0,0,-img.get(0,0)/2);
//		    f.rr(img,img,false,F_DCT,1,F_DCT,1);
		    img.export_image(tmp);
//		};
///	    };
	};
    };

*/


/* //sterge aleatoriu niste frecvente
    Snd snd;
    SndFreq sndfreq;
    snd.import_audio("a.wav");
    Fourier f;
    printf("%d\nFFT\n",snd.getnx());
    f.fft(snd,sndfreq,true);
    int n=sndfreq.getnx();
    for (int i=0;i<n/2;i++){
	if ((random()/32768)%2==0) {
	    sndfreq.set(i,0,0);
	};
    };
    snd.reset(0);
    printf("IFFT\n");
    f.ifft(sndfreq,snd,true);
    snd.export_audio("b.wav");
*/    


/*
//sound 2 image
    Snd snd;
    SndFreq sndfreq;
    snd.import_audio("a.wav");
    Fourier f;
    f.fft(snd,sndfreq,true);
    
    int sndx=sndfreq.getnx();
    int nx=(int)(sqrt(sndx)+1);
    int ny=(int)(sqrt(sndx)+1);
    ImgFreq imgfreq(nx,ny);

    printf("%d %d\n",nx,ny);

    for (int i=0;i<nx/2;i++)
	for (int j=1;j<ny/2;j++){
	    int n=i*ny/2+j;
//	    printf("%d *\n",n);
	    REALTYPE c,s;
	    sndfreq.get(n,c,s);
	    
	    imgfreq.set(i,j,c,s);
//	    sndfreq.get(n+1,c,s);
//	    imgfreq.set(-i,j,c,s);
	};
    sndfreq.reset(0);
    Img img;
    
    f.ifft(imgfreq,img,true);
    img.export_image("a.ppm");


{
// image 2 sound
    Snd snd;
    Img img;
    img.import_image("a.ppm");
    Fourier f;
    ImgFreq imgfreq;
    f.fft(img,imgfreq,true);
    
    int nx=imgfreq.getnx();
    int ny=imgfreq.getnx();
    int sndx=nx*ny;

    printf("%d %d\n",nx,ny);
    SndFreq sndfreq(sndx);

    for (int i=0;i<nx/2;i++)
	for (int j=1;j<ny/2;j++){
	    int n=i*ny/2+j;
	    REALTYPE c,s;
	    imgfreq.get(i,j,c,s);
	    sndfreq.set(n,c,s);
//	    printf("%d\n",(int)(s/c));
//	    imgfreq.get(-i,j,c,s);
//	    sndfreq.set(n+1,c,s);
	};
    imgfreq.reset(0,0);
    
    f.ifft(sndfreq,snd,true);

    snd.export_audio("b.wav");
};
/* */

    

/*
 //diferite transformari r2r la imagine2
    Img img;
    ImgFreq imgfreq;
    Fourier f;
//    for (int kk=0;kk<2;kk++){
//	for (int k=0;k<4;k++){
	    for (int j=0;j<3;j++){
		for (int i=0;i<3;i++){
//		    img.reset(128,128);
		    char tmp[100];
		    snprintf(tmp,100,"%d%d.pgm",j,i);
		    printf("%s\n",tmp);
//		    img.import_image("a.jpg");
		    imgfreq.reset(128,128);
//		    for (int i=0;i<400;i++) {
//			img.set(i%20,i/20,rand()%10-5);
//		    };
		    imgfreq.set(i,j,0.0,1.0);
		    f.idht(imgfreq,img,false);
//		    img.set(0,0,-img.get(0,0)/2);
//		    f.rr(img,img,false,F_DCT,1,F_DCT,1);
		    img.export_image(tmp);
//		};
///	    };
	};
    };
*/
/*
 //test mapping imagine sunet    
    int nx=8;int ny=nx;
    int N=nx*ny;
    Snd snd(N);
    Img img;
    for (int i=0;i<N;i++) snd.set(i,i);
//    snd.debug();
    MapFractal map;
    map.map(snd,img,nx,ny);
    img.debug();
    snd.reset(0);
//    map.map(img,snd,nx,ny);
//    snd.debug();
/**/
/*

// snd2image fisier
    Snd snd;
    Img img;
    MapZigzag map;
    Fourier f;
    if (snd.import_audio("input.wav")){
    
    int N=snd.getnx();
    int nx=(int)(sqrt(N)+0.5);
    int ny=(int)(sqrt(N)+0.5);


    f.rr(snd,snd,false,F_DCT,1);
    map.map(snd,img,nx,ny);
    f.rr(img,img,false,F_DCT,1,F_DCT,1);
    img.export_image("output.pgm");
    };
    {
    //////////
    Snd snd;
    Img img;
    if (img.import_image("input.pgm")) {;
    
    int nx=img.getnx();
    int ny=img.getny();
    int N=nx*ny;
    Fourier f;
    
    f.rr(img,img,false,F_DCT,2,F_DCT,2);
    map.map(img,snd,nx,ny);
    f.rr(snd,snd,false,F_DCT,2);
    snd.export_audio("output.wav");
}
};
/**/
/*//test padsynth
PADsynthGen padsynth;
SndFreq sndfreq;
Snd snd;
Fourier f;
int nx=512,ny=512;
padsynth.generate(sndfreq,nx*ny,44100,30,4.0,120.0,30,1,0.0);
f.ifft(sndfreq,snd,false);
snd.export_audio("a.wav");
MapZigzag map;
Img img;
f.rr(snd,snd,false,F_DCT,1);
map.map(snd,img,nx,ny);
f.rr(img,img,false,F_DCT,2,F_DCT,2);
img.export_image("a.pgm");

*/
/*
//autoconvolutie sunet

Snd snd;
SndFreq sndfreq;
Fourier f;
if (!snd.import_audio("input.wav"))return 0;
printf("FFT\n");
f.fft(snd,sndfreq,true);
int nx=sndfreq.getnx();
for (int i=0;i<nx/2;i++){
    REALTYPE c,s;
    sndfreq.get(i,c,s);
    REALTYPE phase=atan2(s,c);
    REALTYPE amp=sqrt(s*s+c*c);

    phase*=2;
    amp*=amp;

    c=amp*cos(phase);
    s=amp*sin(phase);
    sndfreq.set(i,c,s);
};

printf("IFFT\n");
f.ifft(sndfreq,snd,true);
snd.export_audio("output.wav");

*/


/*

snd2img2snd  FFT Mapping zigzag

Img img;
ImgFreq imgfreq;
SndFreq sndfreq;
Snd snd;
MapZigzag map;
Fourier f;

int nx=0;
int ny=0;
//img2snd
if(img.import_image("input.pgm")){
    int nx=img.getnx();
    int ny=img.getny();
    f.fft(img,imgfreq);
    map.map(imgfreq,sndfreq,nx,ny);
    f.ifft(sndfreq,snd);
    snd.export_audio("output.wav");
};

//snd2img
if (snd.import_audio("input.wav")){
    if ((nx==0)||(ny==0)){
	nx=ny=(int)(sqrt(snd.getnx()));
    };
    f.fft(snd,sndfreq);
    map.map(sndfreq,imgfreq,nx,ny);
    f.ifft(imgfreq,img);
    img.export_image("output.pgm");
};
*/

/*
//Reverberatie

Snd snd;
SndFreq sndfreq,revfreq;
Fourier f;
if (!snd.import_audio("input.wav"))return 0;
printf("FFT snd\n");
f.fft(snd,sndfreq,true);
ExpdecayGen ed;
Snd reverb;
int nx=sndfreq.getnx();
ed.generate(reverb,nx,sndfreq.info_get_samplerate(),16.0,1.1);
printf("FFT reverb\n");
f.fft(reverb,revfreq,true);
for (int i=0;i<nx/2;i++){
    REALTYPE c1,s1,c2,s2,c,s;
    sndfreq.get(i,c1,s1);
    revfreq.get(i,c2,s2);

    c=c1*c2-s1*s2;
    s=c2*s1+c1*s2;

    sndfreq.set(i,c,s);
};

printf("IFFT\n");
f.ifft(sndfreq,snd,true);
snd.export_audio("output.wav");
*/

/* filtered exp decay
ExpdecayGen ed;
Snd snd1;
ed.generate(snd1,100000,22050,16.0,0.9);
SndFreq snd1freq;

Fourier f;
f.fft(snd1,snd1freq,true);
FilterS fs;

fs.combf(snd1freq,snd1freq,200,0.5);

f.ifft(snd1freq,snd1,true);

snd1.export_audio("out.wav");
*/
/*
//LPF 70 Hz sau freq shift
Snd snd;
snd.import_audio("in.wav");
Fourier f;
SndFreq snd1freq;
FilterS fs;
f.fft(snd,snd1freq,true);

int raise=(int)(100.0/snd1freq.info_get_samplerate()*(REALTYPE)snd1freq.getnx());
printf("%d\n",raise);
for (int i=snd1freq.getnx()/2-1;i>0;i--){
    REALTYPE c,s;
    snd1freq.get(i-raise,c,s);
    snd1freq.set(i,c,s);
};

//fs.lpf(snd1freq,snd1freq,70,5);
f.ifft(snd1freq,snd,true);

snd.export_audio("out.wav");
*/

/*
//group delay modify
Snd snd;
SndFreq sndfreq;
Fourier f;
if (!snd.import_audio("input.wav"))return 0;
printf("FFT\n");
f.fft(snd,sndfreq,true);
int nx=sndfreq.getnx();
float ip1=0.0,group=0.0;
float op1=0.0;

for (int i=0;i<nx/2;i++){
    REALTYPE c,s;
    sndfreq.get(i,c,s);
    REALTYPE phase=atan2(s,c);
    REALTYPE amp=sqrt(s*s+c*c);
    
    group=phase-ip1;
    ip1=phase;
    
    group+=1.5;

    
    op1+=group;
    
    phase=op1;
//    amp*=amp;

    c=amp*cos(phase);
    s=amp*sin(phase);
    sndfreq.set(i,c,s);
};
*/

//    Parameters pars("MapFractal");
//    pars.add_int("Master:volume",0,100,50);
//    pars.add_int("Master:panning",-100,100,0);
//    pars.add_real("Sine:phase",0.0,6.28,3.14);
    
//    printf("%d\n",pars.get_int("Master:volume"));

/*interschimbare faze
    Snd snd1,snd2;
    SndFreq sndfreq1,sndfreq2;
    Fourier f;
    
    AInput ai;ai.open("input1.wav");
    int size1=ai.info.nsamples;ai.close();

    ai.open("input2.wav");
    int size2=ai.info.nsamples;ai.close();
    
    int size=(size1>size2)?size1:size2;
    printf("Sample size=%d\n",size);

    if (!snd1.import_audio("input1.wav",0,size))return 1;
    if (!snd2.import_audio("input2.wav",0,size))return 1;
    
    if (snd1.info_get_samplerate()!=snd2.info_get_samplerate()){
	printf("WARNING: samples rate not equal %d != %d\n",snd1.info_get_samplerate(),snd2.info_get_samplerate());
    };
    
    printf("FFT1\n");
    f.fft(snd1,sndfreq1,true);
    printf("FFT2\n");
    f.fft(snd2,sndfreq2,true);

    printf("\nSWAP Phases\n\n");
    int nx1=sndfreq1.getnx();
    int nx2=sndfreq1.getnx();
    int nx=(nx1>nx2)?nx1:nx2;
    for (int i=0;i<nx;i++){
	REALTYPE c,s;
	sndfreq1.get(i,c,s);
	REALTYPE phase1=atan2(s,c);
	REALTYPE amp1=sqrt(s*s+c*c);

	sndfreq2.get(i,c,s);
	REALTYPE phase2=atan2(s,c);
	REALTYPE amp2=sqrt(s*s+c*c);
	
        sndfreq1.set(i,amp1*cos(phase2),amp1*sin(phase2));
        sndfreq2.set(i,amp2*cos(phase1),amp2*sin(phase1));
	
    };
    


    printf("IFFT1\n");
    f.ifft(sndfreq1,snd1,true);
    printf("IFFT2\n");
    f.ifft(sndfreq2,snd2,true);
    
    snd1.export_audio("output1.wav");
    snd2.export_audio("output2.wav");

*/

//};


#include <wx/app.h>
#include <wx/msgdlg.h>
#include "UI/ParametersDialog.h"
#include <wx/choicdlg.h>

class HyperMammuthApp:public wxApp{
    public:
	bool OnInit();
};

IMPLEMENT_APP(HyperMammuthApp)

std::string filedialog(bool save,bool image){
    wxString wildcard=(image?wxT("Image files (*.pgm,*.jpg)|*.pgm;*.jpg|All files (*.*)|*.*"):wxT("Wav files (*.wav,*.WAV)|*.wav;*.WAV|All files (*.*)|*.*"));
    int options=(save?wxSAVE|wxOVERWRITE_PROMPT:wxOPEN|wxFILE_MUST_EXIST);
    wxString defaultfile=wxT("");
    if (save) defaultfile=(image?wxT("output.pgm"):wxT("output.wav"));
    wxFileDialog filedialog(NULL,wxT("Choose file"),wxT(""),defaultfile,wildcard,options);
    std::string result;
    if (filedialog.ShowModal()==wxID_OK){
	result=filedialog.GetFilename().mb_str(wxConvUTF8);
    };
    return result;
};

void process_s2s(){
    wxArrayString ch;
    ch.Add(wxT("Filter"));
    ch.Add(wxT("AmplitudePhase"));
    ch.Add(wxT("PhaseChange"));
    ch.Add(wxT("Translate"));
    wxSingleChoiceDialog dlg(NULL,wxT("Choose effect"),wxT("Snd2Snd"),ch);
    dlg.SetSelection(0);
    if (dlg.ShowModal()==wxID_OK){
	Snd snd;
	bool loaded=true;
	
	if (!snd.import_audio(filedialog(false,false))) {
	    printf("ERROR: Could not import audio file.\n");
	    return;
	};
	Fourier f;
	SndFreq snd1freq;
	Process *fs=NULL;
	switch (dlg.GetSelection()){
	    case 0:
		fs=new FilterS();
	    break;
	    case 1:
		fs=new AmplitudePhaseS();
	    break;
	    case 2:
		fs=new PhaseChangeS();
	    break;
	    case 3:
		fs=new TranslateS();
	    break;
	    default: return;
	};
    
    
	f.fft(snd,snd1freq,true);

	fs->set_input(0,&snd1freq);
	fs->set_output(0,&snd1freq);

	ParametersDialog pardialog(fs);
	pardialog.ShowModal(); 


        fs->process();

	f.ifft(snd1freq,snd,true);

	snd.export_audio(filedialog(true,false));
    };
};

void process_i2i(){
    wxArrayString ch;
    ch.Add(wxT("Filter"));
    ch.Add(wxT("AmplitudePhase"));
    ch.Add(wxT("PhaseChange"));
    ch.Add(wxT("Stretch"));
    wxSingleChoiceDialog dlg(NULL,wxT("Choose effect"),wxT("Img2Img"),ch);
    dlg.SetSelection(0);
    if (dlg.ShowModal()==wxID_OK){
	Img img;
	bool loaded=true;
	
	
	if (!img.import_image(filedialog(false,true))) {
	    printf("ERROR: Could not import image file.\n");
	    return;
	};
	Fourier f;
	ImgFreq img1freq;
	Process *fs=NULL;
	switch (dlg.GetSelection()){
	    case 0:
		fs=new FilterI();
	    break;
	    case 1:
		fs=new AmplitudePhaseI();
	    break;
	    case 2:
		fs=new PhaseChangeI();
	    break;
	    case 3:
		fs=new StretchIF();
	    break;
	    default: return;
	};
    
    
	f.fft(img,img1freq,true);

	fs->set_input(0,&img1freq);
	fs->set_output(0,&img1freq);

	ParametersDialog pardialog(fs);
	pardialog.ShowModal(); 


        fs->process();

	f.ifft(img1freq,img,true);

	img.export_image(filedialog(true,false));
    };
};

void process_s2i_i2s(bool tosound){
    wxArrayString ch;
    ch.Add(wxT("Scanning"));
    ch.Add(wxT("Zigzag"));
    ch.Add(wxT("Fractal"));
    wxSingleChoiceDialog dlg(NULL,wxT("Choose mapping"),(tosound?wxT("Image2Sound"):wxT("Sound2Image")),ch);
    dlg.SetSelection(0);
    if (dlg.ShowModal()==wxID_OK){
	Snd snd;
	Img img;
	
	if (tosound){
	    if (!img.import_image(filedialog(false,true))) {
		return;
	    };
	}else{
	    if (!snd.import_audio(filedialog(false,false))) {
		return;
	    };
	};
	Fourier f;
	SndFreq snd1freq;
	ImgFreq img1freq;
	Process *fs=NULL;
	Mapping::MappingMode mappingmode=(tosound?Mapping::IMGF2SNDF : Mapping::SNDF2IMGF);
	
	switch (dlg.GetSelection()){
	    case 0:
		fs=new MapScanning(mappingmode);
	    break;
	    case 1:
		fs=new MapZigzag(mappingmode);
	    break;
	    case 2:
		fs=new MapFractal(mappingmode);
	    break;
	    default: return;
	};
    
    
	if (tosound) {
	    f.fft(img,img1freq,true);
	    fs->set_input(0,&img1freq);
	    fs->set_output(0,&snd1freq);
	} else{
	    f.fft(snd,snd1freq,true);
	    fs->set_input(0,&snd1freq);
	    fs->set_output(0,&img1freq);
	};


	ParametersDialog pardialog(fs);
	pardialog.ShowModal(); 


        fs->process();

	if (tosound) {
	    f.ifft(snd1freq,snd,true);
	    snd.export_audio(filedialog(true,false));
	} else {
	    f.ifft(img1freq,img,true);
	    img.export_image(filedialog(true,true));
	};

    };
};

bool HyperMammuthApp::OnInit(){
    wxArrayString ch;
    ch.Add(wxT("Sound 2 Sound"));
    ch.Add(wxT("Image 2 Image"));
    ch.Add(wxT("Sound 2 Image (Mapping)"));
    ch.Add(wxT("Image 2 Sound (Mapping)"));
    wxSingleChoiceDialog dlg(NULL,wxT("Choose mode"),wxT(""),ch);
    dlg.SetSelection(0);
    if (dlg.ShowModal()==wxID_OK){
	switch (dlg.GetSelection()){
	    case 0:process_s2s();
		break;
	    case 1:process_i2i();
		break;
	    case 2:process_s2i_i2s(false);
		break;
	    case 3:process_s2i_i2s(true);
		break;
	};

    };
/*    Parameters pars("MapFractal");
    pars.add_par_separator("Categoria 1");
    pars.add_par_int("volume",0,100,50);
    pars.add_par_int("panning1",-100,100,0);
    pars.add_par_separator("Categoria 2");
    pars.add_par_int("panning2",-100,20,0);
    pars.add_par_real("phase",1.0,6.28,3.14,EXP);
    pars.add_par_choice("Mode","Cucu|BAU|MuMu|Cucurigu","Cucu");
    pars.add_par_intcombo("Sample Rate","8000|16000|22050|44100",0,88200,32000);


    ParametersDialog pardialog(pars);
    pardialog.ShowModal(); 
    
    printf("%d %g  %s  %d\n",pars.get_par_int("volume"),pars.get_par_real("phase"),pars.get_par_choice("Mode").c_str(),pars.get_par_int("Sample Rate"));
*/    
  //FILTER cu interfata
/*
   Snd snd;
    bool loaded=true;
    if (!snd.import_audio("in.wav")) {
	printf("ERROR: Could not import audio file.\n");
	loaded=false;
    };
    Fourier f;
    SndFreq snd1freq;
    Process *fs=new FilterS();
    
    
    f.fft(snd,snd1freq,true);

    fs->set_input(0,&snd1freq);
    fs->set_output(0,&snd1freq);

    ParametersDialog pardialog(fs);
    pardialog.ShowModal(); 


    fs->process();

    f.ifft(snd1freq,snd,true);

    if (loaded) snd.export_audio("out.wav");
*/

/* //snd2 img mapping
    Fourier f;
    SndFreq snd1freq;
    Snd snd;
    snd.import_audio("in.wav");
    ImgFreq imgfreq;
    SndFreq sndfreq;
    Img img;
    f.fft(snd,sndfreq,true);

    Process *fs=new MapFractal(Mapping::SNDF2IMGF);

    fs->set_input(0,&sndfreq);
    fs->set_output(0,&imgfreq);

    ParametersDialog pardialog(fs);
    pardialog.ShowModal(); 


    fs->process();


    f.ifft(imgfreq,img,true);

    img.export_image("out.pgm");

*/
/*
 //sndfreq filter
  Snd snd;
    Fourier f;
    SndFreq snd1freq,snd2freq;
    Process *fs=new AmplitudePhaseS();
    ParametersDialog pardialog(fs);
    pardialog.ShowModal(); 

    
    for (int i=1;i<=3;i++){    
	bool loaded=true;
	char tmp[100];
	snprintf(tmp,100,"in%d.wav",i);
	printf("%s\n",tmp);
	if (!snd.import_audio(tmp)) {
	    printf("ERROR: Could not import audio file.\n");
	    loaded=false;
	    continue;
	};

	f.fft(snd,snd1freq,true);

	fs->set_input(0,&snd1freq);
	fs->set_output(0,&snd1freq);

	fs->process();

	f.ifft(snd1freq,snd,true);

	snprintf(tmp,100,"out%d.wav",i);
	if (loaded) snd.export_audio(tmp);
    };
    return false;//test(fortez iesirea din aplicatie)
*/

/* //procesare imagine FFT
    Process *fs=new StretchIF();
    ParametersDialog pardialog(fs);
    pardialog.ShowModal(); 

    Img img;
    ImgFreq imgfreq;
    Fourier f;

    img.import_image("in.jpg");
    f.fft(img,imgfreq,true);

    fs->set_input(0,&imgfreq);
    fs->set_output(0,&imgfreq);
    
    fs->process();
    

    f.ifft(imgfreq,img,true);
    img.export_image("out.jpg");    

    return false;
*/
/*
 //procesare imagine
    Process *fs=new StretchI();
    ParametersDialog pardialog(fs);
    pardialog.ShowModal(); 

    Img img;

    img.import_image("in.jpg");

    fs->set_input(0,&img);
    fs->set_output(0,&img);
    
    fs->process();
    img.export_image("out.jpg");    

    return false;
*/
/*
    //procesare s2i2s (8 Apr 2006)
    Process *fs2=new StretchI();
    ParametersDialog pardialog(fs2);
    pardialog.ShowModal(); 

    for (int i=1;i<=3;i++){    
	bool loaded=true;
	Process *fs=new MapZigzag(Mapping::SNDF2IMGF);
	char tmp[100];
	snprintf(tmp,100,"in%d.wav",i);
	printf("%d\n",i);
	Fourier f;
	SndFreq snd1freq;
	Snd snd;
	if (!snd.import_audio(tmp)) continue;
	ImgFreq imgfreq;
	SndFreq sndfreq;
	Img img;
	f.fft(snd,sndfreq,true);


	fs->set_input(0,&sndfreq);
	fs->set_output(0,&imgfreq);

//    ParametersDialog pardialog(fs);
//    pardialog.ShowModal(); 
	fs->process();
	f.ifft(imgfreq,img,true);
//    printf("sr=%d\n",img.info_get_samplerate());

	snprintf(tmp,100,"out%da.pgm",i);
	img.export_image(tmp);
    //procesarea imaginii
	fs2->set_input(0,&img);
	fs2->set_output(0,&img);
	fs2->process();

	snprintf(tmp,100,"out%db.pgm",i);
	img.export_image(tmp);
	
    //conversie inapoi in sunet
        f.fft(img,imgfreq,true);

	Process *fs3=new MapZigzag(Mapping::IMGF2SNDF);

	fs3->set_input(0,&imgfreq);
        fs3->set_output(0,&sndfreq);
	fs3->process();

	f.ifft(sndfreq,snd,true);
	snprintf(tmp,100,"out%d.wav",i);
        snd.export_audio(tmp);
	delete fs3;
    };

*/
    return false;


    return true;//aplicatia merge
};



